/* VmeInputOutputRegister.kts */
/* Created by Enomoto Sanshiro on 21 December 2002. */
/* Last updated by Enomoto Sanshiro on 21 December 2002. */


datasource VmeInputOutputRegister
{
    int base_address = 0x8000;
    int irq = 3;
    int vector = 0xfff0;

    VmeCrate crate;
    VmeController controller("SBS-620");
    VmeModule io_register("Rinei-RPV130");

    crate.installController(controller);
    crate.installModule(io_register, base_address, irq, vector);

    on run_begin {
	// enable FIN1/FIN2 interrupts //
        io_register.enable(#1..#2);
    }

    on trigger(io_register) {
	// input data //
        Register latch1, latch2, flipflop, through;
        io_register.inputLatch1(latch1);
        io_register.inputLatch2(latch2);
        io_register.inputFlipFlop(flipflop);
        io_register.inputThrough(through);

	// send the data to data-stream/data-file //
        DataRecord input_register;
        input_register.fill("latch1", latch1);
        input_register.fill("latch2", latch2);
        input_register.fill("flipflop", flipflop);
        input_register.fill("through", through);
	input_register.send();

	// output pulse //
        io_register.outputPulse(#0..#7);
    }
}
