/* VmeMemory.kts */
/* Created by Enomoto Sanshiro on 31 May 2000. */
/* Last updated by Enomoto Sanshiro on 5 December 2002. */


datasource VmeMemory
{
    int base_address = 0x02000000;
    long readout_offset = 0x0000;
    long data_size = 0x1000;
    
    VmeCrate crate;
    VmeController controller("SBS-620");
    VmeModule memory("Generic-MemoryA32D32");
    SoftwareModule timer("IntervalTimer");
    
    crate.installController(controller);
    crate.installModule(memory, base_address);
    
    on run_begin {
	// set trigger interval for 100ms //
	timer.setInterval(0, 100000);
    }

    on trigger(timer) {
	// read a block of data from the memory card //
	memory.blockRead(readout_offset, data_size);
    }
}
