/* DataAnalyzer01.cc */


#include <cstdlib>
#include <iostream>
#include <string>
#include "KinokoKdfReader.hh"
#include "KinokoSectionDataAnalyzer.hh"

using namespace std;


static const char* DataSourceName = "";
static const char* SectionName = "adc";


class TMyDataAnalyzer: public TKinokoSectionDataAnalyzer {
  public:
    TMyDataAnalyzer(void);
    virtual ~TMyDataAnalyzer();
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
  protected:
    int _EventCount;
};



TMyDataAnalyzer::TMyDataAnalyzer(void)
: TKinokoSectionDataAnalyzer(SectionName)
{
    _EventCount = 0;
}

TMyDataAnalyzer::~TMyDataAnalyzer()
{
    cout << endl;
    cout << _EventCount << " events were processed." << endl;
}

int TMyDataAnalyzer::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    _EventCount++;

    int Address, Data;
    while (SectionData->GetNext(Address, Data)) {
	cout << Address << " " << Data << endl;
    }

    return 1;
}



int main(int argc, char** argv)
{
    if (argc < 2) {
	cerr << "Usage: " << argv[0] << " DataFileName" << endl;
        return EXIT_FAILURE;
    }
    string DataFileName = argv[1];

    TKinokoKdfReader* KdfReader = new TKinokoKdfReader(DataFileName);
    TKinokoDataAnalyzer* Analyzer = new TMyDataAnalyzer();
    
    try {
	KdfReader->RegisterAnalyzer(DataSourceName, Analyzer);
	KdfReader->Start();
    }
    catch (TKinokoException& e) {
	cerr << "ERROR: " << e << endl;
        return EXIT_FAILURE;
    }

    delete Analyzer;
    delete KdfReader;

    return 0;
}
