/* DataProcessor04.cc */
/* Sample program to read tagged data */


#include <iostream>
#include <iomanip>
#include "MushArgumentList.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"
#include "KinokoTaggedDataSection.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoStandaloneComponent.hh"


using namespace std;


class TMyDataConsumer: public TKinokoDataConsumer {
  public:
    TMyDataConsumer(string DataSourceName, string SectionName);
    virtual ~TMyDataConsumer();
    virtual void OnRunBegin(void) throw(TKinokoException);
    virtual void OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
  protected:
    string _DataSourceName, _SectionName;
    int _DataSourceId, _SectionId;
    TKinokoTaggedDataSection* _DataSection;
    TKinokoTaggedDataSectionScanner* _Scanner;
};



TMyDataConsumer::TMyDataConsumer(string DataSourceName, string SectionName)
{
    _DataSourceName = DataSourceName;
    _SectionName = SectionName;

    _DataSourceId = -1;
    _SectionId = -1;

    _Scanner = 0;
}

TMyDataConsumer::~TMyDataConsumer()
{
}

void TMyDataConsumer::OnRunBegin(void) throw(TKinokoException)
{
    // get DataSource object by name//
    TKinokoDataSource* DataSource = _InputDataDescriptor->DataSource(_DataSourceName);

    if (DataSource != 0) {
	_DataSourceId = DataSource->DataSourceId();
	TKinokoDataSection* DataSection = DataSource->DataSection(_SectionName);

	if (DataSection != 0) {
	    _SectionId = DataSection->SectionId();

	    // check section type and get scanner object //
	    if (DataSection->SectionType() != TKinokoDataSection::SectionType_Tagged) {
		throw TKinokoException("invalid section type");
	    }
	    _DataSection = (TKinokoTaggedDataSection*) DataSection;
	    _Scanner = _DataSection->Scanner();
	}
    }
}

void TMyDataConsumer::OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException)
{
    int DataSourceId = TKinokoDataStreamScanner::DataSourceIdOf(DataPacket);
    if (DataSourceId != _DataSourceId) {
	return;
    }

    int SectionId = TKinokoDataSectionScanner::SectionIdOf(DataPacket);
    if (SectionId != _SectionId) {
	return;
    }

    int NumberOfFields = _DataSection->NumberOfFields();
    int Data;
    for (int Index = 0; Index < NumberOfFields; Index++) {
	string FieldName = _DataSection->FieldNameOf(Index);
	_Scanner->ReadFrom(DataPacket, Index, Data);
	cout << FieldName << " " << Data << endl;
    }
}


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    TMyDataConsumer MyDataConsumer("CamacAdc", "event_info");
    TKinokoStandaloneDataConsumer StandaloneDataConsumer(&MyDataConsumer, "MyDataConsumer");

    try {
	StandaloneDataConsumer.Start(ArgumentList);
    }
    catch (TKinokoException &e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}
