/* DataProcessor05.cc */
/* Sample program to read nested data */


#include <iostream>
#include "MushArgumentList.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"
#include "KinokoIndexedDataSection.hh"
#include "KinokoTaggedDataSection.hh"
#include "KinokoNestedDataSection.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoStandaloneComponent.hh"


using namespace std;


class TMyDataConsumer: public TKinokoDataConsumer {
  public:
    TMyDataConsumer(void);
    virtual ~TMyDataConsumer();
    virtual void OnRunBegin(void) throw(TKinokoException);
    virtual void OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
  protected:
    int _DataSourceId;
    int _EventSectionId;
    TKinokoNestedDataSection* _EventSection;
    TKinokoNestedDataSectionScanner* _EventScanner;
    int _EventInfoSectionId;
    TKinokoTaggedDataSection* _EventInfoSection;
    TKinokoTaggedDataSectionScanner* _EventInfoScanner;
    int _AdcSectionId;
    TKinokoIndexedDataSection* _AdcSection;
    TKinokoIndexedDataSectionScanner* _AdcScanner;
};



TMyDataConsumer::TMyDataConsumer(void)
{
}

TMyDataConsumer::~TMyDataConsumer()
{
}

void TMyDataConsumer::OnRunBegin(void) throw(TKinokoException)
{
    string DataSourceName;
    string SectionName;
    TKinokoDataSource* DataSource;
    TKinokoDataSection* DataSection;
    
    DataSourceName = "CamacAdc";
    DataSource = _InputDataDescriptor->DataSource(DataSourceName);
    if (DataSource == 0) {
	throw TKinokoException("datasouce not found: " + DataSourceName);
    }
    _DataSourceId = DataSource->DataSourceId();
    
    SectionName = "event";
    DataSection = DataSource->DataSection(SectionName);
    if (DataSection == 0) {
	throw TKinokoException("section not found: " + SectionName);
    }
    _EventSectionId = DataSection->SectionId();
    _EventSection = (TKinokoNestedDataSection*) DataSection;
    _EventScanner = _EventSection->Scanner();
    
    SectionName = "event_info";
    DataSection = _EventSection->DataSection(SectionName);
    if (DataSection == 0) {
	throw TKinokoException("section not found: " + SectionName);
    }
    _EventInfoSectionId = DataSection->SectionId();
    _EventInfoSection = (TKinokoTaggedDataSection*) DataSection;
    _EventInfoScanner = _EventInfoSection->Scanner();
    
    SectionName = "adc";
    DataSection = _EventSection->DataSection(SectionName);
    if (DataSection == 0) {
	throw TKinokoException("section not found: " + SectionName);
    }
    _AdcSectionId = DataSection->SectionId();
    _AdcSection = (TKinokoIndexedDataSection*) DataSection;
    _AdcScanner = _AdcSection->Scanner();
}

void TMyDataConsumer::OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException)
{
    int DataSourceId = TKinokoDataStreamScanner::DataSourceIdOf(DataPacket);
    if (DataSourceId != _DataSourceId) {
	cout << "### Unexpected DataSource: ID=" << DataSourceId << endl;
	return;
    }

    int SectionId = TKinokoDataSectionScanner::SectionIdOf(DataPacket);
    if (SectionId != _EventSectionId) {
	cout << "### Unexpected DataSection: ID=" << SectionId << endl;
	return;
    }

    int DataSize = _EventScanner->DataSizeOf(DataPacket);
    U8bit* SubPacket = (U8bit*) _EventScanner->DataAreaOf(DataPacket);

    int SubPacketSize;
    int ProcessedSize = 0;
    while (ProcessedSize < DataSize) {
	int SectionId = TKinokoDataSectionScanner::SectionIdOf(SubPacket);

	if (SectionId == _EventInfoSectionId) {
	    int NumberOfFields = _EventInfoSection->NumberOfFields();
	    int Data;
	    for (int Index = 0; Index < NumberOfFields; Index++) {
		string FieldName = _EventInfoSection->FieldNameOf(Index);
		_EventInfoScanner->ReadFrom(DataPacket, Index, Data);
		cout << FieldName << " " << Data << endl;
	    }
	}
	else if (SectionId == _AdcSectionId) {
	    int NumberOfElements = _AdcScanner->NumberOfElements(DataPacket);
	    int Address, Data;
	    for (int Index = 0; Index < NumberOfElements; Index++) {
		_AdcScanner->ReadFrom(DataPacket, Index, Address, Data);
		cout << Address << " " << Data << endl;
	    }
	}
	else {
	    cout << "### Unexpected DataSection: ID=" << SectionId << endl;
	}

	SubPacketSize = TKinokoDataSectionScanner::PacketSizeOf(SubPacket);
	ProcessedSize += SubPacketSize;
	SubPacket += SubPacketSize;
    }
}


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    TMyDataConsumer MyDataConsumer;
    TKinokoStandaloneDataConsumer StandaloneDataConsumer(&MyDataConsumer, "MyDataConsumer");

    try {
	StandaloneDataConsumer.Start(ArgumentList);
    }
    catch (TKinokoException &e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}



#if 0

This is a sample script to generate data that this program accepts.
- - - - - - - - - - - - 8< - - - - - - - - - - - -
datasource CamacAdc
{
    SoftwareModule adc("PmtSimulator");
    SoftwareModule timer("IntervalTimer");

    DataRecord event_info;
    Register event_number, event_time;

    on run_begin {
        timer.setInterval(0, 100000);
    }

    on trigger(timer) {
	unit Event {
	    adc.read(#0..#3);
	    adc.clear();
	    
	    event_number.add(1);
	    readTime(event_time);
	    event_info.fill("event_number", event_number);
	    event_info.fill("event_time", event_time);
	    event_info.send();
	}
    }
}
- - - - - - - - - - - - 8< - - - - - - - - - - - -

This is the data-descriptor of data that the sample script generates.
- - - - - - - - - - - - 8< - - - - - - - - - - - -
datasource "CamacAdc"<32926>
{
    attribute creator = "tinykinoko";
    attribute creation_date = "2004-07-10 06:19:51 JST";
    attribute script_file = "DataRecord.kts";
    attribute script_file_fingerprint = "b4bb275c";

    section "Event"<257>: nested {
        section "adc"<258>: indexed(address: int-16bit, data: int-16bit);
        section "event_info"<259>: tagged {
            field "event_number": int-32bit;
            field "event_time": int-32bit;
        }
    }
}
- - - - - - - - - - - - 8< - - - - - - - - - - - -

#endif
