/* MyDataProcessor-kcom.cc */
/* Sample program to make a data processor component */


#include <iostream>
#include <iomanip>
#include "MushArgumentList.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoDataProcessorCom.hh"
#include "KcomProcess.hh"


using namespace std;


class TMyDataConsumer: public TKinokoDataConsumer {
  public:
    TMyDataConsumer(void);
    virtual ~TMyDataConsumer();
    virtual void OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
};



TMyDataConsumer::TMyDataConsumer(void)
{
}

TMyDataConsumer::~TMyDataConsumer()
{
}

void TMyDataConsumer::OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException)
{
    // get DataSourceId and SectionId //
    int DataSourceId = TKinokoDataStreamScanner::DataSourceIdOf(DataPacket);
    int SectionId = TKinokoDataSectionScanner::SectionIdOf(DataPacket);

    // get data and data size //
    void* Data = TKinokoDataSectionScanner::DataAreaOf(DataPacket);
    size_t DataSize = TKinokoDataSectionScanner::DataSizeOf(DataPacket);

    // hexadecimal dump //
    cout << "[" << DataSourceId << ":" << SectionId << "]";
    cout << hex << setfill('0');
    for (unsigned Offset = 0; Offset < DataSize; Offset++) {
	if (Offset % 16 == 0) {
	    cout << endl;
	    cout << setw(4) << Offset << ":  ";
	}
	else if (Offset % 8 == 0) {
	    cout << " ";
	}	
	cout << setw(2) << (int) ((unsigned char*) Data)[Offset] << " ";
    }
    cout << dec << setfill(' ') << endl;
}


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    TMyDataConsumer MyDataConsumer;

    TKinokoDataConsumerCom DataConsumerCom(&MyDataConsumer);
    TKcomProcess ComProcess(&DataConsumerCom);

    try {
        ComProcess.Start(ArgumentList);
    }
    catch (TKinokoException &e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}
