/* NestedDataSection.kts */


datasource CamacAdc
{
    SoftwareModule adc("PoissonGenerator");
    int adc_channels = #0..#3;

    DataRecord event_info;
    Register event_number, event_time;

    SoftwareModule timer("IntervalTimer");

    on run_begin {
	timer.setInterval(0, 1000);
    }

    on trigger(timer) {
	event_number += 1;
	readTime(event_time);
	
        unit event {
	    adc.read(adc_channels);
	    adc.clear();

	    event_info.fill("event_number", event_number);
	    event_info.fill("event_time", event_time);
	    event_info.send();
	}
    }
}
