/* MoguraHorizontalBuilder-kcom.cc */
/* Created by Enomoto Sanshiro on 10 September 2009. */
/* Last updated by Enomoto Sanshiro on 10 September 2009. */


#include <iostream>
#include "KcomProcess.hh"
#include "KinokoBuilderCom.hh"
#include "MoguraEventPiece.hh"

using namespace std;

int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);
    
    TKinokoHorizontalBuilderCom* Component = new TKinokoHorizontalBuilderCom();
    TKcomProcess* ComProcess = new TKcomProcess(Component);    

    TKinokoEventPieceScanner* Scanner = new TMoguraEventPieceScanner();
    Component->SetPieceScanner(Scanner);

    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete Scanner;
    delete ComProcess;
    delete Component;

    return 0;
}
