/* KameNtuple.cc */
/* Created by Enomoto Sanshiro on 29 June 2009. */
/* Last updated by Enomoto Sanshiro on 29 June 2009. */


#include <string>
#include <sstream>
#include <iomanip>
#include <map>
#include "KameNtuple.hh"


using namespace std;
using namespace kame;


TKameNtuple::TKameNtuple(void)
: TKameTable()
{
    _LastRowIndex = 0;
    _LastSegmentIndex = 0;
    _HasTypeList = false;
}

TKameNtuple::TKameNtuple(const TKameNtuple& Ntuple)
: TKameTable(Ntuple)
{
    if (this != &Ntuple) {
	_ColumnIndexTypeTable = Ntuple._ColumnIndexTypeTable;
	_SegmentBoundaryList = Ntuple._SegmentBoundaryList;
	_HasTypeList = Ntuple._HasTypeList;
	_LastRowIndex = Ntuple._LastRowIndex;
	_LastSegmentIndex = Ntuple._LastSegmentIndex;
    }
}

TKameNtuple::TKameNtuple(unsigned NumberOfColumns)
: TKameTable(NumberOfColumns)
{
    _LastRowIndex = 0;
    _LastSegmentIndex = 0;
    _HasTypeList = false;
}

TKameNtuple::~TKameNtuple()
{
}

TKameNtuple& TKameNtuple::operator=(const TKameNtuple& Ntuple)
{
    if (this == &Ntuple) {
	return *this;
    }

    TKameTable::operator=(Ntuple);
    _ColumnIndexTypeTable = Ntuple._ColumnIndexTypeTable;
    _SegmentBoundaryList = Ntuple._SegmentBoundaryList;
    _HasTypeList = Ntuple._HasTypeList;
    _LastRowIndex = Ntuple._LastRowIndex;
    _LastSegmentIndex = Ntuple._LastSegmentIndex;

    return *this;
}

void TKameNtuple::SetColumnNameType(unsigned ColumnIndex, const std::string& ColumnName, const std::string& ColumnType)
{
    SetColumnName(ColumnIndex, ColumnName);

    _HasTypeList = (! ColumnType.empty());
    if (_HasTypeList) {
	_ColumnIndexTypeTable[ColumnIndex] = ColumnType;
    }
}

const std::string& TKameNtuple::ColumnTypeOf(unsigned ColumnIndex) const throw(TKameException)
{
    return _ColumnIndexTypeTable[ColumnIndex];
}

bool TKameNtuple::HasTypeList(void) const
{
    return _HasTypeList;
}

void TKameNtuple::BreakSegment(void)
{
    _SegmentBoundaryList.push_back(NumberOfRows());
}

unsigned TKameNtuple::NumberOfSegments(void) const
{
    return _SegmentBoundaryList.size();
}

unsigned TKameNtuple::SegmentIndexOf(unsigned RowIndex) const
{
    unsigned SegmentIndex = (
	(RowIndex >= _LastRowIndex) ? _LastSegmentIndex : 0
    );

    while (SegmentIndex < _SegmentBoundaryList.size()) {
	if (RowIndex < _SegmentBoundaryList[SegmentIndex]) {
	    break;
	}
	SegmentIndex++;
    }

    _LastRowIndex = RowIndex;
    _LastSegmentIndex = SegmentIndex;

    return SegmentIndex;
}
