/* KameObject.hh */
/* Created by Enomoto Sanshiro on 8 July 2009. */
/* Last updated by Enomoto Sanshiro on 8 July 2009. */


#ifndef __KameObject_hh__
#define __KameObject_hh__


#include <string>
#include <vector>
#include <map>
#include "KameDefs.hh"
#include "KameVariant.hh"


namespace kame {


class TKameObject {
  public:
    TKameObject(void);
    virtual ~TKameObject();
    virtual void SetTitle(const std::string& Title);
    virtual std::string Title(void) const;
    inline TKameVariant& Property(const std::string& Name);
    inline const TKameVariant& Property(const std::string& Name) const;
    inline const std::vector<std::string>& PropertyNameList(void) const;
    virtual void ImportProperty(const TKameObject& Object);
  private:
    mutable std::vector<std::string> _PropertyNameList;
    mutable std::map<std::string, TKameVariant> _PropertyTable;
};



TKameVariant& TKameObject::Property(const std::string& Name)
{
    if (_PropertyTable.count(Name) == 0) {
	_PropertyNameList.push_back(Name);
    }

    return _PropertyTable[Name];
}


const TKameVariant& TKameObject::Property(const std::string& Name) const
{
    if (_PropertyTable.count(Name) == 0) {
	_PropertyNameList.push_back(Name);
    }

    return _PropertyTable[Name];
}


const std::vector<std::string>& TKameObject::PropertyNameList(void) const
{
    return _PropertyNameList;
}


}
#endif
