/* KameRootRepository.hh */
/* Created by Enomoto Sanshiro on 26 June 2002. */
/* Last updated by Enomoto Sanshiro on 9 July 2009. */


#ifndef __KameRootRepository_hh__
#define __KameRootRepository_hh__


#include <string>
#include <fstream>
#include "KameConfig.hh"
#include "KameDefs.hh"
#include "KameRepository.hh"


#if IS_ROOT_AVAILABLE
class TFile;


namespace kame {


class TKameRootRepository: public TKameRepository {
  public:
    TKameRootRepository(const std::string& FileName);
    virtual ~TKameRootRepository();
    virtual void SaveNtuple(const TKameNtuple& Ntuple, const std::string& Name) throw(TKameException);
    virtual void LoadNtuple(TKameNtuple& Ntuple, const std::string& Name, int Revision=-1) throw(TKameException);
    virtual void SaveGraph(const TKameGraph& Graph, const std::string& Name) throw(TKameException);
    virtual void LoadGraph(TKameGraph& Graph, const std::string& Name, int Revision=-1) throw(TKameException);
    virtual void SaveHistogram(const TKameHistogram& Histogram, const std::string& Name) throw(TKameException);
    virtual void LoadHistogram(TKameHistogram& Histogram, const std::string& Name, int Revision=-1) throw(TKameException);
    virtual void SaveHistogram2d(const TKameHistogram2d& Histogram, const std::string& Name) throw(TKameException);
    virtual void LoadHistogram2d(TKameHistogram2d& Histogram, const std::string& Name, int Revision=-1) throw(TKameException);
  protected:
    virtual void OpenToWrite(void) throw(TKameException);
    virtual void OpenToRead(void) throw(TKameException);
    virtual void Close(void);
  protected:
    void SavePropertyList(const TKameObject& Object, const std::string& Name) throw(TKameException);
    void LoadPropertyList(TKameObject& Object, const std::string& Name, int Revision = 0) throw(TKameException);
  protected:
    std::string _FileName;
    TFile* _InputFile;
    TFile* _OutputFile;
};

}
#endif
#endif
