/* KameSystemIO.cc */
/* Created by Enomoto Sanshiro on 1 July 2009. */
/* Last updated by Enomoto Sanshiro on 1 July 2009. */


#include <iostream>
#include <cstdio>
#include "KameSystemIO.hh"

using namespace std;
using namespace kame;


static const int DefaultBufferSize = 65500;


TKameCFileStreamBuffer::TKameCFileStreamBuffer(FILE* CFile)
{
    _CFile = CFile;

    _BufferSize = DefaultBufferSize;
    _Buffer = new char[_BufferSize];
    
    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);
    setg(Begin, End, End);
}

TKameCFileStreamBuffer::~TKameCFileStreamBuffer()
{
    delete[] _Buffer;
}

int TKameCFileStreamBuffer::overflow(int ch)
{
    sync();

    if (ch != EOF) {
	*pptr() = ch;
	pbump(1);
    }
    
    return ch;
}

int TKameCFileStreamBuffer::underflow(void)
{
    int Size = fread(_Buffer, sizeof(char), _BufferSize, _CFile);
    if (Size == 0) {
        return EOF;
    }
    else if (Size < 0) {
	// interrupted system call... try again //
	return underflow();
    }

    char* Begin = _Buffer;
    char* Next = _Buffer;
    char* End = _Buffer + Size;
    setg(Begin, Next, End);

    return *gptr();
}

int TKameCFileStreamBuffer::sync(void) 
{
    if (pptr() == _Buffer) {
	return 0;
    }

    int Length = pptr() - _Buffer;
    fwrite(_Buffer, sizeof(char), Length, _CFile);

    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);

    return 0;
}



TKameInputCFileStream::TKameInputCFileStream(FILE* CFile)
: istream(_StreamBuffer = new TKameCFileStreamBuffer(CFile))
{
}

TKameInputCFileStream::~TKameInputCFileStream() 
{
    delete _StreamBuffer;
}

TKameCFileStreamBuffer* TKameInputCFileStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}


TKameOutputCFileStream::TKameOutputCFileStream(FILE* CFile)
: ostream(_StreamBuffer = new TKameCFileStreamBuffer(CFile))
{
}

TKameOutputCFileStream::~TKameOutputCFileStream() 
{
    delete _StreamBuffer;
}

TKameCFileStreamBuffer* TKameOutputCFileStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}
