/* KameSystemIO.hh */
/* Created by Enomoto Sanshiro on 1 July 2009. */
/* Last updated by Enomoto Sanshiro on 1 July 2009. */


#ifndef __KameSystemIO_hh__
#define __KameSystemIO_hh__

#include <iostream>
#include <cstdio>


namespace kame {

class TKameCFileStreamBuffer: public std::streambuf {
  public:
    TKameCFileStreamBuffer(std::FILE* CFile);
    virtual ~TKameCFileStreamBuffer();
  protected:
    virtual int overflow(int ch = EOF);
    virtual int underflow(void);
    virtual int sync(void);
  private:
    std::FILE* _CFile;
    char *_Buffer;
    int _BufferSize;
};


class TKameInputCFileStream: public std::istream {
  public:
    TKameInputCFileStream(std::FILE* CFile);
    virtual ~TKameInputCFileStream();
    virtual TKameCFileStreamBuffer* rdbuf(void);
  private:
    TKameCFileStreamBuffer* _StreamBuffer;
};


class TKameOutputCFileStream: public std::ostream {
  public:
    TKameOutputCFileStream(std::FILE* CFile);
    virtual ~TKameOutputCFileStream();
    virtual TKameCFileStreamBuffer* rdbuf(void);
  private:
    TKameCFileStreamBuffer* _StreamBuffer;
};

}
#endif
