/* graph-test.cc */
/* Created by Enomoto Sanshiro on 12 August 2002. */
/* Last updated by Enomoto Sanshiro on 8 July 2009. */


#include <iostream>
#include "KameGraph.hh"
#include "KamePlainTextRepository.hh"
#include "KameRootRepository.hh"

using namespace std;
using namespace kame;


int main(int argc, char** argv)
{
    TKameGraph Graph;

    if (argc > 1) {
	// load a graph from a repository //
	try {
	    TKamePlainTextRepository Repository(argv[1]);
	    //TKameRootRepository Repository(argv[1]);
	    Repository.LoadGraph(Graph, "test");
	}
	catch (TKameException &e) {
	    cerr << "ERROR: " << e << endl;
	    return -1;
	}
    }
    else {
	// create and fill a graph //
	Graph.SetTitle("this is a test");
	for (int i = 0; i < 100; i++) {
	    if ((i % 10) == 0) {
		Graph.BreakSegment();
	    }
	    double X = i;
	    double Y = X*X;
	    Graph.Fill(X, Y);
	}
    }

    // show the graph //
    unsigned NumberOfPoints = Graph.NumberOfPoints();
    unsigned SegmentIndex = 0;
    unsigned NextSegmentBoundary = Graph.SegmentSizeOf(SegmentIndex);
    const double* XValueList = Graph.XValueList();
    const double* YValueList = Graph.YValueList();
    for (unsigned i = 0; i < NumberOfPoints; i++) {
	if (i == NextSegmentBoundary) {
	    NextSegmentBoundary += Graph.SegmentSizeOf(++SegmentIndex);
	    cout << endl;
	}
	cout << XValueList[i] << " " << YValueList[i] << endl;
    }

    // save the graph into a repository //
    try {
	TKamePlainTextRepository Repository("test-graph");
	//TKameRootRepository Repository("test-graph.root");

	Repository.SaveGraph(Graph, "test");
    }
    catch (TKameException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    return 0;
}
