/* kntdump.cc */
/* Created by Enomoto Sanshiro on 1 July 2009. */
/* Last updated by Enomoto Sanshiro on 1 July 2009. */


#include <string>
#include <iostream>
#include <sstream>
#include "KameNtuple.hh"
#include "KamePlainTextRepository.hh"
#include "KameRootRepository.hh"

using namespace std;
using namespace kame;


int main(int argc, char** argv)
{
    if (argc <= 1) {
	cerr << "USAGE: " << argv[0] << " FILENAME" << endl;
	return -1;
    }

    TKameNtuple Ntuple;
    try {
	TKamePlainTextRepository Repository;
	Repository.SetLineTerminator(Repository.MacLineTerminator());
	Repository.LoadNtuple(Ntuple, argv[1]);
    }
    catch (TKameException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    for (unsigned i = 0; i < Ntuple.NumberOfColumns(); i++) {
	cout << "[" << Ntuple.ColumnNameOf(i) << "]";
	cout << (Ntuple[0][i].IsString() ? "s" : "n") << " ";
    }
    cout << endl;
    cout << "---------------" << endl;
    for (unsigned i = 0; i < Ntuple.NumberOfRows(); i++) {
	for (unsigned j = 0; j < Ntuple.NumberOfColumns(); j++) {
#if 0
	    int Column = j;
#else
	    string Column = Ntuple.ColumnNameOf(j);
#endif
	    cout << "[" << Ntuple[i][Column] << "]";
	    cout << (Ntuple[i][j].IsString() ? "s" : "n");
	    cout << " ";
	}
	cout << endl;
    }

    return 0;
}
