/* ntuple-test.cc */
/* Created by Enomoto Sanshiro on 1 July 2009. */
/* Last updated by Enomoto Sanshiro on 1 July 2009. */


#include <string>
#include <iostream>
#include <sstream>
#include "KameNtuple.hh"
#include "KamePlainTextRepository.hh"
#include "KameRootRepository.hh"

using namespace std;
using namespace kame;


#define USE_PLAINTEXT_REPOSITORY 1


int main(int argc, char** argv)
{
    TKameNtuple Ntuple;
    int n = 10, m = 4;

    if (argc > 2) {
	// loading a ntuple from a repository //
	try {
#ifdef USE_PLAINTEXT_REPOSITORY
	    TKamePlainTextRepository InputRepository(argv[1]);
#else
	    TKameRootRepository InputRepository(argv[1]);
#endif
	    InputRepository.LoadNtuple(Ntuple, argv[2]);
	}
	catch (TKameException &e) {
	    cerr << "ERROR: " << e << endl;
	    return -1;
	}
    }
    else if (argc > 1) {
	// loading a ntuple from a repository //
	try {
#ifdef USE_PLAINTEXT_REPOSITORY
	    TKamePlainTextRepository InputRepository;
	    InputRepository.LoadNtuple(Ntuple, argv[1]);
#else
	    TKameRootRepository InputRepository(argv[1]);
	    InputRepository.LoadNtuple(Ntuple, "test");
#endif
	}
	catch (TKameException &e) {
	    cerr << "ERROR: " << e << endl;
	    return -1;
	}
    }
    else {
	// creating a new ntuple //
	for (int j = 0; j < m; j++) {
	    ostringstream ColumnName;
	    ColumnName << "Column#";
	    if (j % 2) {
		ColumnName << " ";
	    }
	    ColumnName << j;
	    if (j % 2) {
		Ntuple.SetColumnNameType(j, ColumnName.str(), "float");
	    }
	    else {
		Ntuple.SetColumnNameType(j, ColumnName.str(), "string");
	    }
	}
	for (int i = 0; i < n; i++) {
	    for (int j = 0; j < m; j++) {
		if (j % 2) {
		    Ntuple[i][j] = (i+1)*(j+1);
		}
		else {
		    Ntuple[i][j] = "#o#";
		}
	    }
	}

	Ntuple.Property("Title") = "Kame Ntuple Test";
	Ntuple.Property("CreationDate") = time(NULL);
    }

    // show the properties //
    for (unsigned i = 0; i < Ntuple.PropertyNameList().size(); i++) {
	string Name = Ntuple.PropertyNameList()[i];
	string Value = Ntuple.Property(Name);
	cout << "# " << Name << ": " << Value << endl;
    }
    cout << endl;

    // showing the ntuple //
    for (unsigned i = 0; i < Ntuple.NumberOfColumns(); i++) {
	cout << "[" << Ntuple.ColumnNameOf(i) << "]";
	cout << (Ntuple[0][i].IsString() ? "s" : "n") << " ";
    }
    cout << endl;
    cout << "---------------" << endl;
    for (unsigned i = 0; i < Ntuple.NumberOfRows(); i++) {
	for (unsigned j = 0; j < Ntuple.NumberOfColumns(); j++) {
	    cout << "[" << Ntuple[i][j] << "]";
	    cout << (Ntuple[i][j].IsString() ? "s" : "n");
	    cout << " ";
	}
	cout << endl;
    }

    // saving the ntuple into a repository //
    try {
#ifdef USE_PLAINTEXT_REPOSITORY
	TKamePlainTextRepository Repository("test-ntuple");
	//Repository.EnableCompression();
	//Repository.SetHeaderDelimiter(",");
	//Repository.SetHeaderQuote("\"");
	//Repository.SetDelimiter(",");
	//Repository.SetQuote("\"");
#else
	TKameRootRepository Repository("test-ntuple.root");
#endif
	
	Repository.SaveNtuple(Ntuple, "test");
#if 0
	// revision test //
	Ntuple[0][0] = "hello, world.";
	Ntuple[1][0] = "hello\\,\\ world.";
	Ntuple[2][0] = "hello\\,\\ \\\"kame\\\"\\ world.";
	Ntuple[0][1] = 999;
	Repository.SaveNtuple(Ntuple, "test");
#endif
    }
    catch (TKameException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    return 0;
}
