/* KaspGraph.cc */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 29 June 2002. */


#include <cstring>
#include <string>
#include <algorithm>
#include "KaspGraph.hh"


using namespace std;


TKaspGraph::TKaspGraph(const string& Title, unsigned InitialListSize)
: TKaspObject(Title)
{
    _ListSize = InitialListSize;

    _XValueList = new double[_ListSize];
    _YValueList = new double[_ListSize];
    _XErrorList = new double[_ListSize];
    _YErrorList = new double[_ListSize];
    
    Clear();
}

TKaspGraph::~TKaspGraph()
{
    delete[] _XValueList;
    delete[] _YValueList;
    delete[] _XErrorList;
    delete[] _YErrorList;
}

void TKaspGraph::Clear(void)
{
    _NumberOfPoints = 0;
    _HasErrors = false;

    _XMin = 0;
    _XMax = 0;
    _YMin = 0;
    _YMax = 0;

    _CurrentSegmentStartOffset = 0;
    if (! _SegmentSizeList.empty()) {
	_SegmentSizeList.erase(
	    _SegmentSizeList.begin(), _SegmentSizeList.end()
	);
    }
}

bool TKaspGraph::HasData(void)
{
    return (_NumberOfPoints > 0);
}

void TKaspGraph::ResizeList(double*& List, unsigned NewSize, unsigned NumberOfData)
{
    double* OldList = List;
    List = new double[NewSize];

    if (NumberOfData > 0) {
	memcpy(List, OldList, NumberOfData * sizeof(double));
    }

    delete[] OldList;
}

void TKaspGraph::BreakSegment(void)
{
    int CurrentSegmentSize = _NumberOfPoints - _CurrentSegmentStartOffset;
    _SegmentSizeList.push_back(CurrentSegmentSize);

    _CurrentSegmentStartOffset = _NumberOfPoints;
}

unsigned TKaspGraph::NumberOfSegments(void)
{
    return _SegmentSizeList.size();
}

unsigned TKaspGraph::SegmentSizeOf(unsigned SegmentIndex)
{
    if (_SegmentSizeList.empty()) {
	return _NumberOfPoints;
    }
    else if (SegmentIndex < _SegmentSizeList.size()) {
	return _SegmentSizeList[SegmentIndex];
    }
    else {
	return 0;
    }
}
