/* KaspRepository.cc */
/* Created by Enomoto Sanshiro on 26 June 2002. */
/* Last updated by Enomoto Sanshiro on 26 June 2002. */


#include <string>
#include "KaspRepository.hh"
#include "KaspPlainTextRepository.hh"
#include "KaspXmlRepository.hh"
#include "KaspRootRepository.hh"
#include "KaspRepositoryFactory.hh"

using namespace std;


TKaspRepositoryFactory* TKaspRepositoryFactory::_PlainTextRepositoryFactory = 0;
TKaspRepositoryFactory* TKaspRepositoryFactory::_XmlRepositoryFactory = 0;
TKaspRepositoryFactory* TKaspRepositoryFactory::_RootRepositoryFactory = 0;


TKaspRepositoryFactory::TKaspRepositoryFactory(void)
{
}

TKaspRepositoryFactory::~TKaspRepositoryFactory()
{
}

TKaspRepositoryFactory* TKaspRepositoryFactory::GetInstance(const string& Type)
{
    if (Type == "PlainText") {
	if (_PlainTextRepositoryFactory == 0) {
	    _PlainTextRepositoryFactory = new TKaspPlainTextRepositoryFactory();
	}
	return _PlainTextRepositoryFactory;
    }

    if (Type == "Xml") {
	if (_XmlRepositoryFactory == 0) {
	    _XmlRepositoryFactory = new TKaspXmlRepositoryFactory();
	}
	return _XmlRepositoryFactory;
    }

    if (Type == "Root") {
	if (_RootRepositoryFactory == 0) {
	    _RootRepositoryFactory = new TKaspRootRepositoryFactory();
	}
	return _RootRepositoryFactory;
    }

    return 0;
}



TKaspPlainTextRepositoryFactory::TKaspPlainTextRepositoryFactory(void)
{
}

TKaspPlainTextRepositoryFactory::~TKaspPlainTextRepositoryFactory()
{
}

TKaspRepository* TKaspPlainTextRepositoryFactory::CreateRepository(const string& Name)
{
    return new TKaspPlainTextRepository(Name);
}



TKaspXmlRepositoryFactory::TKaspXmlRepositoryFactory(void)
{
}

TKaspXmlRepositoryFactory::~TKaspXmlRepositoryFactory()
{
}

TKaspRepository* TKaspXmlRepositoryFactory::CreateRepository(const string& Name)
{
    return new TKaspXmlRepository(Name);
}



TKaspRootRepositoryFactory::TKaspRootRepositoryFactory(void)
{
}

TKaspRootRepositoryFactory::~TKaspRootRepositoryFactory()
{
}

TKaspRepository* TKaspRootRepositoryFactory::CreateRepository(const string& Name)
{
#if IS_ROOT_AVAILABLE
    return new TKaspRootRepository(Name);
#else
    return 0;
#endif
}
