/* KaspTrend.cc */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Last updated by Enomoto Sanshiro on 29 June 2002. */


#include <cmath>
#include <string>
#include "KaspTrend.hh"

using namespace std;



TKaspTrend::TKaspTrend(const string& Title, long TickInterval, long WindowLength)
: TKaspObject(Title)
{
    _Interval = TickInterval;
    _Length = WindowLength;

    _Depth = (_Length / _Interval) + 1;

    _CountsStorage = new double[_Depth];
    _SumStorage = new double[_Depth];
    _SumOfSqrStorage = new double[_Depth];

    Clear();
}

TKaspTrend::~TKaspTrend()
{
    delete[] _CountsStorage;
    delete[] _SumStorage;
    delete[] _SumOfSqrStorage;
}

void TKaspTrend::Clear(void)
{
    _BaseIndex = 0;
    _NumberOfPoints = 0;

    _StartTime = 0;
    _MinTime = _StartTime;
    _MaxTime = _MinTime + _Interval * _NumberOfPoints;
}

void TKaspTrend::Start(long StartTime)
{
    _StartTime = StartTime;
    _MinTime = _StartTime;
    _MaxTime = _MinTime + _Interval * _NumberOfPoints;
}

void TKaspTrend::UpdateRange(long MaxTimeStamp)
{
    while (MaxTimeStamp >= _MaxTime) {
	int Index;
	if (_NumberOfPoints < _Depth) {
	    _NumberOfPoints++;
	    Index = (_BaseIndex + _NumberOfPoints - 1) % _Depth;
	}
	else {
	    Index = _BaseIndex;
	    _BaseIndex = (_BaseIndex + 1) % _Depth;
	}
	_CountsStorage[Index] = 0;
	_SumStorage[Index] = 0;
	_SumOfSqrStorage[Index] = 0;
	_MaxTime += _Interval;
    }
    _MinTime = _MaxTime - _Interval * _NumberOfPoints;
}
