/* KaspWave.hh */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 29 June 2002. */


#ifndef __KaspWave_hh__
#define __KaspWave_hh__


#include <string>
#include <vector>
#include "KaspObject.hh"


class TKaspWave: public TKaspObject {
  public:
    TKaspWave(const std::string& Title, int InitialStorageCapacity = 1024);
    ~TKaspWave();
    void Clear(void);
    bool HasData(void);
  public:
    inline void Fill(int Index, double Value);
    inline int NumberOfPoints(void) const;
    inline double ValueOf(int Index) const;
  protected:
    std::vector<double> _Storage;
    std::vector<unsigned long> _DataCountList;
    int _NumberOfPoints;
};



inline void TKaspWave::Fill(int Index, double Value)
{
    if (Index >= _NumberOfPoints) {
	_NumberOfPoints = Index + 1;
	if (_NumberOfPoints > (int) _Storage.size()) {
	    _Storage.resize(2 * _NumberOfPoints, 0);
	    _DataCountList.resize(2 * _NumberOfPoints, 0);
	}
    }

    _Storage[Index] += Value;
    _DataCountList[Index]++;
}

inline double TKaspWave::ValueOf(int Index) const
{
    if ((Index >= _NumberOfPoints) || (_DataCountList[Index] == 0)) {
	return 0;
    }

    return _Storage[Index] / _DataCountList[Index];
}

inline int TKaspWave::NumberOfPoints(void) const
{
    return _NumberOfPoints;
}


#endif
