/* graph-test.cc */
/* Created by Enomoto Sanshiro on 12 August 2002. */
/* Last updated by Enomoto Sanshiro on 23 December 2002. */


#include <iostream>
#include "KaspGraph.hh"
#include "KaspPlainTextRepository.hh"
#include "KaspXmlRepository.hh"
#include "KaspRootRepository.hh"

using namespace std;


int main(int argc, char** argv)
{
    TKaspGraph* Graph = 0;

    if (argc > 2) {
	// load a graph from a repository //
	try {
	    TKaspPlainTextRepository Repository(argv[1]);
	    Graph = Repository.LoadGraph(argv[2]);
	}
	catch (TKaspException &e) {
	    cerr << "ERROR: " << e << endl;
	    return -1;
	}
    }
    else {
	// create and fill a graph //
	Graph = new TKaspGraph("this is a test");
	for (double X = 0; X < 32; X += 1.0) {
	    Graph->Fill(X, X*X);
	}
    }

    // show the graph //
    unsigned NumberOfPoints = Graph->NumberOfPoints();
    unsigned SegmentIndex = 0;
    unsigned NextSegmentBoundary = Graph->SegmentSizeOf(SegmentIndex);
    const double* XValueList = Graph->XValueList();
    const double* YValueList = Graph->YValueList();
    for (unsigned i = 0; i < NumberOfPoints; i++) {
	if (i == NextSegmentBoundary) {
	    NextSegmentBoundary += Graph->SegmentSizeOf(++SegmentIndex);
	    cout << endl;
	}
	cout << XValueList[i] << " " << YValueList[i] << endl;
    }

    // save the graph into a repository //
    try {
	TKaspPlainTextRepository Repository("test-graph");
	//TKaspXmlRepository Repository("test-graph.xml");
	//TKaspRootRepository Repository("test-graph.root");

	Repository.SaveGraph("test", Graph);
    }
    catch (TKaspException &e) {
	cerr << "ERROR: " << e << endl;
	delete Graph;
	return -1;
    }

    delete Graph;

    return 0;
}
