/* ntuple-test.cc */
/* Created by Enomoto Sanshiro on 10 August 2002. */
/* Last updated by Enomoto Sanshiro on 23 December 2002. */


#include <iostream>
#include "KaspNtuple.hh"
#include "KaspPlainTextRepository.hh"
#include "KaspXmlRepository.hh"
#include "KaspRootRepository.hh"

using namespace std;


int main(int argc, char** argv)
{
    TKaspNtuple* Ntuple = 0;

    if (argc > 1) {
	// loading a ntuple from a repository //
	try {
	    TKaspPlainTextRepository InputRepository(argv[1]);
	    Ntuple = InputRepository.LoadNtuple("test");
	}
	catch (TKaspException &e) {
	    cerr << "ERROR: " << e << endl;
	    return -1;
	}
    }
    else {
	// creating and filling a ntuple //
	Ntuple = new TKaspNtuple("this is a test", 3);
	double Data[3];
	for (int i = 0; i < 32; i++) {
	    Data[0] = i;
	    Data[1] = 2 * i;
	    Data[2] = i * i;
	    Ntuple->Fill(Data);
	}
    }

    // showing a ntuple //
    for (unsigned i = 0; i < Ntuple->NumberOfColumns(); i++) {
	cout << Ntuple->ColumnNameOf(i) << " ";
    }
    cout << endl;
    cout << "---------------" << endl;
    for (unsigned i = 0; i < Ntuple->NumberOfRows(); i++) {
	for (unsigned j = 0; j < Ntuple->NumberOfColumns(); j++) {
	    cout << (*Ntuple)[i][j] << " ";
	}
	cout << endl;
    }

    // saving a ntuple into a repository //
    try {
	TKaspPlainTextRepository Repository("test-ntuple");
	//TKaspXmlRepository Repository("test-ntuple.xml");
	//TKaspRootRepository Repository("test-ntuple.root");
	
	Repository.EnableGzipCompression();

	Repository.SaveNtuple("test", Ntuple);

	// revision test //
	double Data[3] = {123, 456, 789};
	Ntuple->Fill(Data);
	Repository.SaveNtuple("test", Ntuple);
    }
    catch (TKaspException &e) {
	cerr << "ERROR: " << e << endl;
	delete Ntuple;
	return -1;
    }

    delete Ntuple;

    return 0;
}
