/* trend-test.cc */
/* Created by Enomoto Sanshiro on 13 February 2008. */
/* Last updated by Enomoto Sanshiro on 13 February 2008. */


#include <iostream>
#include <cstdlib>
#include <cmath>
#include <time.h>
#include "KaspTrend.hh"
#include "KaspPlainTextRepository.hh"
#include "KaspXmlRepository.hh"
#include "KaspRootRepository.hh"

using namespace std;


int main(int argc, char** argv)
{
    TKaspTrend* Trend = 0;

    if (argc > 1) {
	// load a trend from a repository //
	try {
	    TKaspPlainTextRepository Repository(argv[1]);
	    Trend = Repository.LoadTrend("test");
	}
	catch (TKaspException &e) {
	    cerr << "ERROR: " << e << endl;
	    return -1;
	}
    }
    else {
	// create and fill a trend //
	Trend = new TKaspTrend("this is a test", 10, 100);
	long TimeStamp = time(NULL);
	Trend->Start(TimeStamp);

	srand48(time(NULL));
	double Value;
	for (int i = 0; i < 1200; i++) {
	    Value = sqrt(-2.0 * log(drand48())) * cos(2 * M_PI * drand48());
	    Value += 5 + i/600.0;
	    Trend->Fill(TimeStamp, Value);

	    if (((i+1) % 10) == 0) {
		TimeStamp++;
	    }
	}
	
	Trend->UpdateRange(TimeStamp + 25);
    }

    // show the trend //
    unsigned NumberOfPoints = Trend->NumberOfPoints();
    for (unsigned i = 0; i < NumberOfPoints; i++) {
	cout << Trend->TimeOf(i) << " ";
	cout << Trend->CountsOf(i) << " ";
	cout << Trend->SumOf(i) << " ";
	cout << Trend->MeanOf(i) << " ";
	cout << Trend->DeviationOf(i) << " ";
	cout << endl;
    }

    // save the trend into a repository //
    try {
	TKaspPlainTextRepository Repository("test-trend");
	//TKaspXmlRepository Repository("test-trend.xml");
	//TKaspRootRepository Repository("test-trend.root");

	Repository.SaveTrend("test", Trend);
    }
    catch (TKaspException &e) {
	cerr << "ERROR: " << e << endl;
	delete Trend;
	return -1;
    }

    delete Trend;

    return 0;
}
