/* commander-kcom.cc */
/* Created by Enomoto Sanshiro on 12 May 2000. */
/* Last updated by Enomoto Sanshiro on 12 May 2000. */


#include <iostream>
#include <sstream>
#include <string>
#include "MushNetworkSocket.hh"
#include "ParaTokenizer.hh"
#include "KcomComponent.hh"
#include "KcomProcess.hh"

using namespace std;


static const string Author = "Enomoto Sanshiro";
static const string Date = "12 May 2000";
static const int MajorVersion = 0;
static const int MinorVersion = 1;


class TCommanderCom: public TKcomComponent {
  public:
    TCommanderCom(void);
    virtual ~TCommanderCom();
    virtual int DoTransaction(void) throw(TKcomException);
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual void ProcessLocalCommand(TParaTokenizer* Tokenizer);
  private:
    enum TEventId {
	EventId_Any,
	_NumberOfEvents
    }; 
};


TCommanderCom::TCommanderCom(void)
: TKcomComponent("Commander")
{
}

TCommanderCom::~TCommanderCom()
{
}

void TCommanderCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKcomComponent::BuildDescriptor(Descriptor);
    
    Descriptor.SetAuthor(Author);
    Descriptor.SetDate(Date);
    Descriptor.SetVersion(MajorVersion, MinorVersion);

    Descriptor.AddComment("Just transfer command to event processor.");
    Descriptor.AddComment("Enter '.quit' to exit.");
}

int TCommanderCom::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    Event.Dump(OutputStream());
    OutputStream() << endl;
    
    return TCommanderCom::ProcessEvent(EventId, Event, EventResponse);
}

int TCommanderCom::DoTransaction(void) throw(TKcomException)
{
    static char Buffer[256];
    OutputStream() << "commander> " << flush;
    if (! InputStream().getline(Buffer, sizeof(Buffer), '\n')) {
	return 0;
    }
    
    istringstream CommandStream(Buffer);
    TParaCxxTokenTable TokenTable;
    TParaTokenizer Tokenizer(CommandStream, &TokenTable);

    if (Tokenizer.LookAhead().Is(".")) {
	ProcessLocalCommand(&Tokenizer);
	return 0;
    }

    TParaToken Token = Tokenizer.Next();
    Token.MustBe(TParaToken::ttIdentifier);
    string EventName = Token.AsString();

    TKcomEvent Event;
    try {
	Tokenizer.Next().MustBe("(");

	if ((Token = Tokenizer.Next()).IsNot(")")) {
	    Tokenizer.Unget(Token);
	    
	    while (1) {
		Token = Tokenizer.Next();
		Token.MustBe(TParaToken::ttIdentifier);
		string Argument = Token.AsString();
		Event.ArgumentList().push_back(Argument);
		
		if ((Token = Tokenizer.Next()).Is(")")) {
		    break;
		}
		else {
		    Token.MustBe(",");
		}
	    }
	}
	
	Tokenizer.Next().MustBe(";");
    }
    catch (TScriptException &e) {
	OutputStream() << "syntax error: " << e << endl;
	return 0;
    }

    Event.Name() = EventName;
    EmitEvent(EventId_Any, Event);

    return 1;
}

void TCommanderCom::ProcessLocalCommand(TParaTokenizer* Tokenizer)
{
    Tokenizer->Next().MustBe(".");
    string Command = Tokenizer->Next().AsString();

    if (Command == "quit") {
	Terminate();
    }
}


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    TKcomComponent* Component = new TCommanderCom();
    TKcomProcess* ComProcess = new TKcomProcess(Component);

    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete ComProcess;
    delete Component;

    return 0;
}
