/* KcomComponentOrb.cc */
/* Created by Enomoto Sanshiro on 25 March 2000. */
/* Last updated by Enomoto Sanshiro on 6 April 2002. */


#include <unistd.h>

#include <string>
#include "KorbOrb.hh"
#include "KorbObjectAdapter.hh"
#include "KorbObjectMessenger.hh"
#include "KorbNamingContext.hh"
#include "KcomComponent.hh"
#include "KcomEvent.hh"
#include "KcomComponentOrb.hh"

using namespace std;


TKcomComponentProxy::TKcomComponentProxy(const TKorbObjectReference& ObjRef, TKorbOrb* Orb)
{
    _ObjRef = ObjRef;
    _Orb = Orb;
}

TKcomComponentProxy::~TKcomComponentProxy()
{
}

const TKorbObjectReference& TKcomComponentProxy::ObjectReference(void) const
{
    return _ObjRef;
}

int TKcomComponentProxy::EmitEvent(TKcomEvent& Event, bool IsOneWay) throw(TKcomException)
{
    TKorbOrbPacket OrbPacket = _Orb->CreateClientOrbPacket(_ObjRef);
    OrbPacket.MethodId() = TKcomComponentMessenger::MethodId_DispatchEvent;
    OrbPacket.IsOneWay() = (IsOneWay ? 1 : 0);
    OrbPacket.ArgumentSerializer().PutObject(Event);

    int RequestId = 0;
    try {
	RequestId = _Orb->InvokeMethod(_ObjRef, OrbPacket, 0, true);
    }
    catch (TKorbException &e) {
	throw TKcomException(
	    "TKcomComponentProxy::EmitEvent()",
	    "korb exception: " + e.Message()
	);
    }

    return RequestId;
}

int TKcomComponentProxy::WaitEventResponse(int RequestId, TKcomEventResponse& EventResponse, int TimeOut_sec) throw(TKcomException)
{
    int Result = 0;
    if (RequestId <= 0) {
	return Result;
    }

    TKorbOrbPacket OrbPacket = _Orb->CreateClientOrbPacket(_ObjRef);
    try {
	Result = _Orb->WaitReplyFor(RequestId, OrbPacket, TimeOut_sec);
    }
    catch (TKorbException &e) {
	throw TKcomException(
	    "TKcomComponentProxy::WaitResponse()",
	    "korb exception: " + e.Message()
	);
    }

    if (Result > 0) {
	OrbPacket.ArgumentSerializer().GetObject(EventResponse);
    }

    return Result;
}



TKcomComponentMessenger::TKcomComponentMessenger(TKcomComponent* Component)
: TKorbObjectMessenger(Component->TypeName())
{
    _Component = Component;
}

TKcomComponentMessenger::~TKcomComponentMessenger()
{
}

int TKcomComponentMessenger::DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException)
{
    int Result = 0;

    try {
	if (OrbPacket.MethodId() == MethodId_DispatchEvent) {
	    TKcomEvent Event;
	    OrbPacket.ArgumentSerializer().GetObject(Event);

	    TKcomEventResponse EventResponse;
	    Result = _Component->DispatchEvent(Event, EventResponse);

	    if (Result == 0) {
		string ErrorMessage = (
		    "no such event slot: " +
		    _Component->ComponentName() + "." + Event.Name()
		);
		EventResponse.IsError() = 1;
		EventResponse.ReturnValue() = ErrorMessage;
	    }

	    OrbPacket.ArgumentSerializer().Rewind();
	    OrbPacket.ArgumentSerializer().PutObject(EventResponse);
	}
    }
    catch (TKcomException &e) {
	throw TKorbException(
	    "TKcomComponentMessenger::DispatchMethodInvocation()",
	    "kcom exception: " + e.Message()
	);
    }

    return Result;
}
