/* KcomEvent.cc */
/* Created by Enomoto Sanshiro on 30 March 2000. */
/* Last updated by Enomoto Sanshiro on 6 April 2002. */


#include <iostream>
#include <string>
#include <vector>
#include "KorbStreamable.hh"
#include "KorbSerializer.hh"
#include "KcomEvent.hh"

using namespace std;


TKcomEvent::TKcomEvent(void)
{
}

TKcomEvent::TKcomEvent(const string& Name)
{
    _Name = Name;
}

TKcomEvent::~TKcomEvent()
{
}

string& TKcomEvent::Name(void)
{
    return _Name;
}

string& TKcomEvent::SourceName(void)
{
    return _SourceName;
}

vector<string>& TKcomEvent::ArgumentList(void)
{
    return _ArgumentList;
}

int TKcomEvent::WriteTo(void* Buffer, int BufferSize) const
{
    TKorbSerializer Serializer(Buffer, BufferSize);

    Serializer.PutString(_Name);
    Serializer.PutString(_SourceName);
    
    int NumberOfArguments = _ArgumentList.size();
    Serializer.PutInt(NumberOfArguments);

    for (int i = 0; i < NumberOfArguments; i++) {
	Serializer.PutString(_ArgumentList[i]);
    }
    
    return Serializer.ProcessedSize();
}

int TKcomEvent::ReadFrom(void* Buffer, int BufferSize)
{
    _ArgumentList.erase(_ArgumentList.begin(), _ArgumentList.end());

    TKorbSerializer Serializer(Buffer, BufferSize);

    Serializer.GetString(_Name);
    Serializer.GetString(_SourceName);
    
    int NumberOfArguments;
    Serializer.GetInt(NumberOfArguments);
    
    for (int i = 0; i < NumberOfArguments; i++) {
        string Argument;
	Serializer.GetString(Argument);
	_ArgumentList.push_back(Argument);
    }
    
    return Serializer.ProcessedSize();
}

void TKcomEvent::Dump(ostream& os) 
{
    os << _SourceName << ".";
    os << _Name << "(";
#if 1
    for (unsigned i = 0; i < _ArgumentList.size(); i++) {
	os << "\"" << _ArgumentList[i] << "\"";
	if (i + 1 < _ArgumentList.size()) {
	    os << ", ";
	}
    }
#endif
    os << ")" << flush;
}



TKcomEventResponse::TKcomEventResponse(void)
{
    _IsError = 0;
}

TKcomEventResponse::~TKcomEventResponse()
{
}

int& TKcomEventResponse::IsError(void)
{
    return _IsError;
}

string& TKcomEventResponse::ReturnValue(void)
{
    return _ReturnValue;
}

int TKcomEventResponse::WriteTo(void* Buffer, int BufferSize) const
{
    TKorbSerializer Serializer(Buffer, BufferSize);

    Serializer.PutInt(_IsError);
    Serializer.PutString(_ReturnValue);
    
    return Serializer.ProcessedSize();
}

int TKcomEventResponse::ReadFrom(void* Buffer, int BufferSize)
{
    TKorbSerializer Serializer(Buffer, BufferSize);

    Serializer.GetInt(_IsError);
    Serializer.GetString(_ReturnValue);
    
    return Serializer.ProcessedSize();
}
