/* KcomManager.hh */
/* Created by Enomoto Sanshiro on 28 March 2000. */
/* Updated by Enomoto Sanshiro on 1 August 2001. */
/* Last updated by Enomoto Sanshiro on 19 January 2010. */


#ifndef __KcomManager_hh__
#define __KcomManager_hh__


#include <string>
#include <map>
#include "MushProcess.hh"
#include "KorbCommander.hh"
#include "KorbOrb.hh"
#include "KorbObjectAdapter.hh"
#include "KorbObjectMessenger.hh"
#include "KorbObjectReference.hh"
#include "KcomDefs.hh"
#include "KcomRegistry.hh"
#include "KcomRegistryOrb.hh"
#include "KcomExchangeCenter.hh"
#include "KcomComponentAssembler.hh"
#include "KcomObjectAssembler.hh"



class TKcomManager {
  public:
    TKcomManager(void);
    virtual ~TKcomManager();
    virtual int Start(void) throw(TKcomException);
    virtual int Stop(void) throw(TKcomException);
    virtual int LaunchRemoteBroker(const std::string& HostName, const std::string& RemoteWorkingDirectory) throw(TKcomException);
    virtual int DomainIdOf(const std::string& HostName) throw(TKcomException);
  public:
    virtual TKcomComponentAssembler* GetComponentAssembler(void) = 0;
    virtual TKcomObjectAssembler* GetObjectAssembler(void) = 0;
    virtual TKcomEventProcessor* GetEventProcessor(void) = 0;
    virtual TKcomRegistry* GetRegistry(void);
  protected:
    virtual void Construct(TKorbCommander* Commander, TKorbOrb* Orb) throw(TKcomException) = 0;
    virtual void OnStartup(void) throw(TKcomException) {}
    virtual void OnShutdown(void) throw(TKcomException) {}
    virtual int DoTransaction(void) throw(TKcomException);
  protected:
    virtual void Initialize(void) throw(TKcomException);
    virtual int Finalize(void) throw(TKcomException);
    virtual void LaunchRegistryServer(void) throw(TKcomException);
    virtual void TerminateRegistryServer(void) throw(TKcomException);
  private:
    TKorbOrb* _Orb;
    TKorbObjectAdapter* _ObjectAdapter;
    TKorbCommander* _KorbCommander;
    TKcomExchangeCenter* _ExchangeCenter;
    TMushChildProcess* _RegistryProcess;
    TKorbObjectMessenger* _ExchangeCenterMessenger;
    TKorbObjectReference _RegistryReference;
    TKcomRegistryProxy* _Registry;
    std::map<unsigned long, int> _DomainIdTable;
    bool _IsStopRequested;
    std::string _KcomPath;
};


#endif

