/* KcomObjectAssembler.hh */
/* Created by Enomoto Sanshiro on 17 August 2000. */
/* Last updated by Enomoto Sanshiro on 17 August 2000. */


#ifndef __KcomObjectAssembler_hh__
#define __KcomObjectAssembler_hh__

#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "KorbOrb.hh"
#include "KorbObjectReference.hh"
#include "KcomDefs.hh"


class TKcomAssignment {
  public:
    TKcomAssignment(const std::string& ProviderName, const std::string& ProviderObjectName, const std::string& UserName, const std::string& UserObjectName);
    virtual ~TKcomAssignment();
    virtual const std::string& ProviderName(void) const;
    virtual const std::string& ProviderObjectName(void) const;
    virtual const std::string& UserName(void) const;
    virtual const std::string& UserObjectName(void) const;
    virtual std::string ExportName(void) const;
    virtual std::string ImportName(void) const;
    virtual void Dump(std::ostream& os, const std::string& Indent = "") const;
  private:
    std::string _ProviderName;
    std::string _ProviderObjectName;
    std::string _UserName;
    std::string _UserObjectName;
};



class TKcomObjectAssembler {
  public:
    TKcomObjectAssembler(TKorbOrb* Orb);
    virtual ~TKcomObjectAssembler();
    virtual void AddAssignment(const TKcomAssignment& Assignment);
    virtual std::string AssignedObjectOf(const std::string& ImportName);
    virtual int LookupObject(const std::string& ImportName, TKorbObjectReference& ObjectReference) throw(TKcomException);
    virtual int LookupService(const std::string& ClassName, TKorbObjectReference& ObjectReference) throw(TKcomException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "") const;
  private:
    TKorbOrb* _Orb;
    std::vector<TKcomAssignment> _AssignmentList;
    std::map<std::string, std::string> _AssignmentTable;
    std::map<std::string, TKorbObjectReference> _ExportObjectTable;
    std::map<std::string, TKorbObjectReference> _ServiceObjectTable;
};


#endif

