/* KcomRegistry.hh */
/* Created by Enomoto Sanshiro on 26 May 2000. */
/* Last updated by Enomoto Sanshiro on 19 May 2003. */


#ifndef __KcomRegistry_hh__
#define __KcomRegistry_hh__

#include <string>
#include <vector>
#include "KcomDefs.hh"


class TKcomRegistryEntry {
  public:
    TKcomRegistryEntry(const std::string& Name);
    TKcomRegistryEntry(const std::string& Name, const std::string& Value);
    virtual ~TKcomRegistryEntry();
    virtual void SetValue(const std::string& Value);
    virtual void AddChildEntry(TKcomRegistryEntry* ChildEntry);
    virtual const std::string& Name(void) const;
    virtual const std::string& Value(void) const;
    virtual const std::vector<TKcomRegistryEntry*>& ChildEntryList(void) const;
  protected:
    std::string _Name;
    std::string _Value;
    std::vector<TKcomRegistryEntry*> _ChildEntryList;
};


class TKcomRegistry {
  public:
    TKcomRegistry(void);
    virtual ~TKcomRegistry();
    virtual void SetValue(const std::string& RegistryPath, const std::string& Value);
    virtual void SetLongValue(const std::string& RegistryPath, long Value);
    virtual bool GetValue(const std::string& RegistryPath, std::string& Value);
    virtual bool GetLongValue(const std::string& RegistryPath, long &Value);
    virtual std::vector<std::string> ChildEntryNameListOf(const std::string& RegistryPath);
    virtual int GetSequenceValue(const std::string& SequenceName = "");
    virtual void SaveTo(const std::string& FileName, const std::string& BasePath = "") throw(TKcomException);
  public:
    TKcomRegistryEntry* GetEntry(std::string RegistryPath, TKcomRegistryEntry* BaseEntry = 0);
  protected:
    TKcomRegistryEntry* _RootEntry;
};


#endif

