/* KcomRegistryRepository.hh */
/* Created by Enomoto Sanshiro on 27 May 2000. */
/* Last updated by Enomoto Sanshiro on 29 October 2005. */


#ifndef __KcomRegistryRepository_hh__
#define __KcomRegistryRepository_hh__

#include <string>
#include "KcomDefs.hh"
#include "KcomRegistry.hh"


class TKcomRegistryRepository {
  public:
    TKcomRegistryRepository(const std::string& FileName);
    virtual ~TKcomRegistryRepository();
    virtual void Save(TKcomRegistry* Registry, const std::string& BasePath = "/") throw(TKcomException);
    virtual TKcomRegistry* Load(void) throw(TKcomException);
  protected:
    virtual void WriteChildEntries(TKcomRegistryEntry* Entry, std::ostream& os, std::string Indent = "");
  protected:
    std::string _FileName;
};


#endif
