/* KcomScriptedManager.hh */
/* Created by Enomoto Sanshiro on 28 March 2000. */
/* Last updated by Enomoto Sanshiro on 11 April 2000. */


#ifndef __KcomScriptedManager_hh__
#define __KcomScriptedManager_hh__


#include <string>
#include "KcomManager.hh"
#include "KcomEventProcessor.hh"
#include "KcomComponentAssembler.hh"
#include "KcomObjectAssembler.hh"
#include "KcomScript.hh"


class TKcomScriptedEventProcessor;

class TKcomScriptedManager: public TKcomManager {
  public:
    TKcomScriptedManager(const std::string& ScriptFileName, int argc, char** argv);
    virtual ~TKcomScriptedManager();
  protected:
    virtual void Construct(TKorbCommander* Commander, TKorbOrb* Orb) throw(TKcomException);
    virtual void OnStartup(void) throw(TKcomException);
    virtual void OnShutdown(void) throw(TKcomException);
    virtual int DoTransaction(void) throw(TKcomException);
  public:
    virtual TKcomComponentAssembler* GetComponentAssembler(void);
    virtual TKcomObjectAssembler* GetObjectAssembler(void);
    virtual TKcomEventProcessor* GetEventProcessor(void);
  private:
    std::string _ScriptFileName;
    int _argc;
    char** _argv;
    TKcomScript* _Script;
    TKcomScriptedEventProcessor* _ScriptedEventProcessor;
    TKcomComponentAssembler* _ComponentAssembler;
    TKcomObjectAssembler* _ObjectAssembler;
};



class TKcomScriptedEventProcessor: public TKcomEventProcessor {
  public:
    TKcomScriptedEventProcessor(TKorbOrb* Orb);
    virtual ~TKcomScriptedEventProcessor();
    virtual void RegisterScript(TKcomScript* Script);
    virtual int ProcessEvent(TKcomEvent& Event) throw(TKcomException);
  protected:
    TKcomScript* _Script;
};


#endif

