/* KcomTerminal.cc */
/* Created by Enomoto Sanshiro on 16 April 2000. */
/* Last updated by Enomoto Sanshiro on 30 April 2000. */


#include <fstream>
#include <string>
#include "MushProcess.hh"
#include "MushTimer.hh"
#include "KorbOrb.hh"
#include "KorbObjectMessenger.hh"
#include "KorbObjectAdapter.hh"
#include "KorbNamingContext.hh"
#include "KcomTerminal.hh"

using namespace std;


TKcomTerminal::TKcomTerminal(void)
{
}

TKcomTerminal::~TKcomTerminal()
{
}



TKcomTerminalProxy::TKcomTerminalProxy(const TKorbObjectReference& ObjectReference, TKorbOrb* Orb)
{
    _ObjectReference = ObjectReference;
    _Orb = Orb;
}

TKcomTerminalProxy::~TKcomTerminalProxy()
{
}

int TKcomTerminalProxy::Put(const string& Line) throw(TKcomException)
{
    static const int MethodId = TKcomTerminalMessenger::MethodId_Put;
    static const bool IsOneWay = true;

    TKorbOrbPacket OrbPacket = _Orb->CreateClientOrbPacket(_ObjectReference);
    OrbPacket.MethodId() = MethodId;
    OrbPacket.IsOneWay() = IsOneWay;
    OrbPacket.ArgumentSerializer().PutString(Line);

    try {
	_Orb->InvokeMethod(_ObjectReference, OrbPacket);
    }
    catch (TKorbException& e) {
	throw TKcomException(
	    "TKcomTerminalProxy::Put()",
	    "korb exception: " + e.Message()
	);
    }

    int Result;
    if (! IsOneWay) {
	OrbPacket.ArgumentSerializer().GetInt(Result);
    }
    else {
	Result = 1;
    }

    return Result;
}

int TKcomTerminalProxy::Get(string& Line, char Delimiter) throw(TKcomException)
{
    static const int MethodId = TKcomTerminalMessenger::MethodId_Get;

    TKorbOrbPacket OrbPacket = _Orb->CreateClientOrbPacket(_ObjectReference);
    OrbPacket.MethodId() = MethodId;
    OrbPacket.ArgumentSerializer().PutInt(Delimiter);

    try {
	_Orb->InvokeMethod(_ObjectReference, OrbPacket);
    }
    catch (TKorbException& e) {
	throw TKcomException(
	    "TKcomTerminalProxy::Get()",
	    "korb exception: " + e.Message()
	);
    }

    int Result;
    OrbPacket.ArgumentSerializer().GetInt(Result);
    OrbPacket.ArgumentSerializer().GetString(Line);

    return Result;
}

void TKcomTerminalProxy::SetPrompt(const string& Prompt) throw(TKcomException)
{
    static const int MethodId = TKcomTerminalMessenger::MethodId_SetPrompt;
    static const bool IsOneWay = true;

    TKorbOrbPacket OrbPacket = _Orb->CreateClientOrbPacket(_ObjectReference);
    OrbPacket.MethodId() = MethodId;
    OrbPacket.IsOneWay() = IsOneWay;
    OrbPacket.ArgumentSerializer().PutString(Prompt);

    try {
	_Orb->InvokeMethod(_ObjectReference, OrbPacket);
    }
    catch (TKorbException& e) {
	throw TKcomException(
	    "TKcomTerminalProxy::Get()",
	    "korb exception: " + e.Message()
	);
    }
}



TKcomTerminalMessenger::TKcomTerminalMessenger(TKcomTerminal* KcomTerminal)
: TKorbObjectMessenger("KcomTerminal")
{
    _KcomTerminal = KcomTerminal;
}

TKcomTerminalMessenger::~TKcomTerminalMessenger()
{
}

int TKcomTerminalMessenger::DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException) 
{
    if (OrbPacket.MethodId() == MethodId_Put) {
	string Line;
	OrbPacket.ArgumentSerializer().GetString(Line);
	int Result = _KcomTerminal->Put(Line);

	OrbPacket.ArgumentSerializer().Rewind();
	OrbPacket.ArgumentSerializer().PutInt(Result);
    }
    else if (OrbPacket.MethodId() == MethodId_Get) {
	string Line; int Delimiter;
	OrbPacket.ArgumentSerializer().GetInt(Delimiter);
	int Result = _KcomTerminal->Get(Line, Delimiter);

	OrbPacket.ArgumentSerializer().Rewind();
	OrbPacket.ArgumentSerializer().PutInt(Result);
	OrbPacket.ArgumentSerializer().PutString(Line);
    }
    else if (OrbPacket.MethodId() == MethodId_SetPrompt) {
	string Prompt;
	OrbPacket.ArgumentSerializer().GetString(Prompt);
	_KcomTerminal->SetPrompt(Prompt);
    }
    else {
	return 0;
    }

    return 1;
}



TKcomTerminalServer::TKcomTerminalServer(const string& Name, TKcomTerminal* KcomTerminal)
{
    _Name = Name;
    _KcomTerminal = KcomTerminal;

    _Orb = new TKorbOrb();
    _KcomTerminalMessenger = new TKcomTerminalMessenger(_KcomTerminal);

    _ObjectAdapter = _Orb->ObjectAdapter();
}

TKcomTerminalServer::~TKcomTerminalServer()
{
    delete _KcomTerminalMessenger;
    delete _Orb;
}

void TKcomTerminalServer::Start(void) throw(TKcomException)
{
    try {
	_ObjectAdapter->AddMessenger(_KcomTerminalMessenger, _Name);
	_ObjectAdapter->Start();
	_ObjectAdapter->RemoveMessenger(_Name);
    }
    catch (TKorbException &e) {
	throw TKcomException(
	    "TKcomTerminalServer::Start()",
	    "korb exception: " + e.Message()
	);
    }
}



TKcomTerminalClient::TKcomTerminalClient(const string& Name, TKorbOrb* Orb)
{
    _Name = Name;
    _ServerName = _Name + "-kcomterminal";
    _Orb = Orb;

    _KcomTerminal = 0;
}

TKcomTerminalClient::~TKcomTerminalClient()
{
    delete _KcomTerminal;
}

TKcomTerminal* TKcomTerminalClient::Attach(void) throw(TKcomException)
{
    LaunchServer();

    try {
	TKorbNamingContext* NamingContext = _Orb->NamingContext();
	TMushRealTimeTimer Timer(0, 200000);
	do {
	    // Wait for the ServerProcess to be started.
	    // Note that X-server launchs processes after the window 
	    // positions are fixed. It can be very slow.
	    Timer.Suspend();
	} while (! NamingContext->LookupObject(_ServerName, _Reference));
	_KcomTerminal = new TKcomTerminalProxy(_Reference, _Orb);
    }
    catch (TKorbException& e) {
	throw TKcomException(
	    "TKcomTerminalServer::Attach()",
	    "korb exception: " + e.Message()
	);
    }

    return _KcomTerminal;
}

void TKcomTerminalClient::Detach(void) throw(TKcomException)
{
    try {
	_Orb->TerminateAdapter(_Reference);
    }
    catch (TKorbException &e) {
	throw TKcomException(
	    "TKcomTerminalClient::Detach()",
	    "korb exception: " + e.Message()
	);
    }
}
