/* startstop-kcom.cc */
/* Created by Enomoto Sanshiro on 27 March 2000. */
/* Last updated by Enomoto Sanshiro on 27 March 2000. */


#include <iostream>
#include <string>
#include "MushTimer.hh"
#include "KcomComponent.hh"
#include "KcomProcess.hh"
#include "MessageBoard.hh"

using namespace std;


static const string Author = "Enomoto Sanshiro";
static const string Date = "27 Mar 2000";
static const int MajorVersion = 0;
static const int MinorVersion = 1;


class TStartstopCom: public TKcomComponent {
  public:
    TStartstopCom(void);
    virtual ~TStartstopCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual void Initialize(void) throw(TKcomException);
    virtual void Finalize(void) throw(TKcomException);
    virtual int DoTransaction(void) throw(TKcomException);
  private:
    string _UserName;
    TMessageBoardProxy* _MessageBoard;
  private:
    enum TEventId {
	EventId_Start,
	EventId_Stop,
	EventId_Clear,
	EventId_Quit,
	_NumberOfEvents
    };
    enum TPropertyId {
	PropertyId_UserName,
	_NumberOfProperties
    };
};


TStartstopCom::TStartstopCom(void)
: TKcomComponent("StartStopCom")
{
    _MessageBoard = 0;
}

TStartstopCom::~TStartstopCom()
{
    delete _MessageBoard;
}

void TStartstopCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKcomComponent::BuildDescriptor(Descriptor);

    Descriptor.SetAuthor(Author);
    Descriptor.SetDate(Date);
    Descriptor.SetVersion(MajorVersion, MinorVersion);
    
    Descriptor.AddComment("sample component process for KinokoComponents");
    Descriptor.AddComment("simply emits start()/stop() event");

    Descriptor.RegisterProperty(
	PropertyId_UserName, TKcomPropertyDeclaration(
	    "user_name",TKcomPropertyDeclaration::Type_String
	)
    );

    _MessageBoard = new TMessageBoardProxy();
    Descriptor.RegisterImportObject(
    	_MessageBoard, TKcomObjectDeclaration(
	    _MessageBoard->ClassName(), "message_board"
	)
    );

    Descriptor.RegisterEventSource(
	EventId_Start, TKcomEventDeclaration("start")
    );
    Descriptor.RegisterEventSource(
	EventId_Stop, TKcomEventDeclaration("stop")
    );
    Descriptor.RegisterEventSource(
	EventId_Clear, TKcomEventDeclaration("clear")
    );
    Descriptor.RegisterEventSource(
	EventId_Quit, TKcomEventDeclaration("quit")
    );
}

void TStartstopCom::Initialize(void) throw(TKcomException)
{
    static char UserNameBuffer[64];
    OutputStream() << "Enter your name> " << flush;
    InputStream().getline(UserNameBuffer, sizeof(UserNameBuffer));

    _UserName = UserNameBuffer;
    if (*(_UserName.end() - 1) == '\r') {
	_UserName.erase(_UserName.end() - 1, _UserName.end());
    }

    OutputStream() << "Hello, " << _UserName << "." << endl;

    SetProperty(PropertyId_UserName, _UserName);
}

void TStartstopCom::Finalize(void) throw(TKcomException)
{
}

int TStartstopCom::DoTransaction(void) throw(TKcomException)
{
    string Command;
    TKcomEvent Event;

    OutputStream() << "1:start, 0:stop, c:clear, q:quit> " << flush;
    if (getline(InputStream(), Command, '\n')) {
	if (Command == "1") {
	    _MessageBoard->Write(_UserName, "start");
	    EmitEvent(EventId_Start, Event);
	}
	else if (Command == "0") {
	    _MessageBoard->Write(_UserName, "stop");
	    EmitEvent(EventId_Stop, Event);
	}
	else if (Command == "c") {
	    _MessageBoard->Write(_UserName, "clear");
	    EmitEvent(EventId_Clear, Event);
	}
	else if (Command == "q") {
	    _MessageBoard->Write(_UserName, "quit");
	    EmitEvent(EventId_Quit, Event);
	    Terminate();
	}
    }

    return 1;
}



int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    TKcomComponent* Component = new TStartstopCom();
    TKcomProcess* ComProcess = new TKcomProcess(Component);

    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete ComProcess;
    delete Component;

    return 0;
}
