/* KdbcResult.cc */
/* Created by Enomoto Sanshiro on 3 November 2000. */
/* Last updated by Enomoto Sanshiro on 3 November 2000. */


#include <iostream>
#include <sstream>
#include <string>
#include "KdbcDefs.hh"
#include "KdbcResult.hh"

using namespace std;


TKdbcResult::TKdbcResult(void)
{
    _CurrentRow = -1;

    _NumberOfRows = 0;
    _NumberOfColumns = 0;
    _NumberOfAffectedRows = 0;
}

TKdbcResult::~TKdbcResult()
{
}

bool TKdbcResult::IsQueryResult(void)
{
    return _IsQueryResult;
}

long TKdbcResult::NumberOfRows(void) throw(TKdbcException)
{
    return _NumberOfRows;
}

long TKdbcResult::NumberOfColumns(void) throw(TKdbcException)
{
    return _NumberOfColumns;
}

long TKdbcResult::NumberOfAffectedRows(void) throw(TKdbcException)
{
    return _NumberOfAffectedRows;
}

bool TKdbcResult::Next(void)
{
    if (++_CurrentRow >= _NumberOfRows) {
	return false;
    }

    return true;
}

string TKdbcResult::GetString(long Column) throw(TKdbcException)
{
    return GetValueOf(_CurrentRow, Column);
}

string TKdbcResult::GetString(const string& FieldName) throw(TKdbcException)
{
    return GetValueOf(_CurrentRow, FieldName);
}

long TKdbcResult::GetLong(long Column) throw(TKdbcException)
{
    string StringValue = GetValueOf(_CurrentRow, Column);
    istringstream ValueStream(StringValue);

    long LongValue;
    if (! (ValueStream >> LongValue)) {
	throw TKdbcException(
	    "TKdbcResult::GetLong()",
	    "unable to convert to long: " + StringValue
	);
    }

    return LongValue;
}

long TKdbcResult::GetLong(const string& FieldName) throw(TKdbcException)
{
    string StringValue = GetValueOf(_CurrentRow, FieldName);
    istringstream ValueStream(StringValue);

    long LongValue;
    if (! (ValueStream >> LongValue)) {
	throw TKdbcException(
	    "TKdbcResult::GetLong()",
	    "unable to convert to long: " + StringValue
	);
    }

    return LongValue;
}

double TKdbcResult::GetDouble(long Column) throw(TKdbcException)
{
    string StringValue = GetValueOf(_CurrentRow, Column);
    istringstream ValueStream(StringValue);

    double DoubleValue;
    if (! (ValueStream >> DoubleValue)) {
	throw TKdbcException(
	    "TKdbcResult::GetDouble()",
	    "unable to convert to double: " + StringValue
	);
    }

    return DoubleValue;
}

double TKdbcResult::GetDouble(const string& FieldName) throw(TKdbcException)
{
    string StringValue = GetValueOf(_CurrentRow, FieldName);
    istringstream ValueStream(StringValue);

    double DoubleValue;
    if (! (ValueStream >> DoubleValue)) {
	throw TKdbcException(
	    "TKdbcResult::GetDouble()",
	    "unable to convert to double: " + StringValue
	);
    }

    return DoubleValue;
}

void TKdbcResult::Dump(ostream& os)
{
    long NumberOfColumns = this->NumberOfColumns();

    os << "=====" << endl;
    for (long Column = 0; Column < NumberOfColumns; Column++) {
	os << this->FieldNameOf(Column) << " ";
    }
    os << endl;
    os << "---" << endl;
    
    while (this->Next()) {
	for (long Column = 0; Column < NumberOfColumns; Column++) {
	    os << this->GetString(Column) << " ";
	}
	os << endl;
    }
    os << "=====" << endl;
}
