/* dbms-MySQL.hh */
/* Created by Enomoto Sanshiro on 19 June 2002. */
/* Last updated by Enomoto Sanshiro on 28 September 2002. */


#ifndef __dbms_MySQL_hh__
#define __dbms_MySQL_hh__


#include <string>
#include <map>
#include <mysql.h>
#include "KdbcManager.hh"
#include "KdbcDriver.hh"
#include "KdbcResult.hh"



class TKdbcDriver_MySQL: public TKdbcDriver {
  public:
    TKdbcDriver_MySQL(void);
    virtual ~TKdbcDriver_MySQL();
    virtual TKdbcDriver* Clone(void);
    virtual TKdbcConnection* CreateConnection(const std::string& DatabaseName) throw(TKdbcException);
    virtual TKdbcConnection* CreateConnection(const std::string& DatabaseName, const std::string& Host, const std::string& Port, const std::string& UserName, const std::string& Password) throw(TKdbcException);
  protected:
    static MYSQL* _RootConnection;
};



class TKdbcConnection_MySQL: public TKdbcConnection {
  public:
    TKdbcConnection_MySQL(MYSQL* Connection);
    virtual ~TKdbcConnection_MySQL();
    virtual void Disconnect(void);
    virtual TKdbcResult* ExecuteSql(const std::string& Statement) throw(TKdbcException);
  protected:
    MYSQL* _Connection;
};



class TKdbcResult_MySQL: public TKdbcResult {
  public:
    TKdbcResult_MySQL(MYSQL_RES* Result, long NumberOfAffectedRows);
    virtual ~TKdbcResult_MySQL();
    virtual void Destroy(void);
    virtual bool Next(void);
    virtual std::string FieldNameOf(long Column) throw(TKdbcException);
    virtual std::string GetValueOf(long Raw, long Column) throw(TKdbcException);
    virtual std::string GetValueOf(long Raw, const std::string& FieldName) throw(TKdbcException);
  protected:
    MYSQL_RES* _Result;
    MYSQL_ROW _CurrentRowData;
    long _CurrentRowDataRow;
    std::map<std::string, long>* _FieldIndexTable;
};


#endif
