/* sqltest.cc */
/* Created by Enomoto Sanshiro on 3 November 2000. */
/* Last updated by Enomoto Sanshiro on 3 November 2000. */


#include <iostream>
#include "KdbcManager.hh"
#include "KdbcDriver.hh"
#include "KdbcResult.hh"

using namespace std;


int main(int argc, char** argv)
{
    if (argc < 3) {
	cerr << "usage: " << argv[0] << " driver_name database_name" << endl;
	return -1;
    }
    char *DriverName = argv[1];
    char *DatabaseName = argv[2];

    TKdbcDriver* Driver = 0;
    TKdbcConnection* Connection = 0;
    try {
	Driver = TKdbcManager::GetInstance()->CreateDriver(DriverName);
	Connection = Driver->CreateConnection(DatabaseName);
    }
    catch (TKdbcException &e) {
	delete Connection;
	delete Driver;
	cerr << e << endl;
	return -1;
    }

    string Query;
    TKdbcResult* Result = 0;
    while (cout << "sql> ", getline(cin, Query)) {
	try {
	    Result = Connection->ExecuteSql(Query);
	}
	catch (TKdbcException &e) {
	    cerr << e << endl;
	    continue;
	}

	if (Result->IsQueryResult()) {
	    int NumberOfColumns = Result->NumberOfColumns();
	    for (int Column = 0; Column < NumberOfColumns; Column++) {
		cout << Result->FieldNameOf(Column) << " ";
	    }
	    cout << endl;
	    cout << "---" << endl;
	    
	    while (Result->Next()) {
		for (int Column = 0; Column < NumberOfColumns; Column++) {
		    cout << Result->GetString(Column) << " ";
		}
		cout << endl;
	    }
	    cout << "(" << Result->NumberOfRows() << " rows)" << endl;
	}
	else {
	    cout << Result->NumberOfAffectedRows() << " rows affected" << endl;
	}
	cout << endl;

	delete Result;
    }

    delete Connection;
    delete Driver;
    cout << endl;

    return 0;
}
