/* KiscConfigFile.hh */
/* Created by Enomoto Sanshiro on 18 July 2001 */
/* Last updated by Enomoto Sanshiro on 18 July 2001. */


#ifndef __KiscConfigFile_hh__
#define __KiscConfigFile_hh__


#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "ParaTokenizer.hh"
#include "ParaValue.hh"


class TKiscConfigFile {
  public:
    TKiscConfigFile(const std::string& FileName);
    virtual ~TKiscConfigFile();
    virtual void SetTargetSection(const std::string& SectionName, const std::string& Qualifier = "");
    virtual TParaValue GetValueOf(const std::string& EntryName) throw(TScriptException);
    virtual TParaValue GetValueOfWithDefault(const std::string& EntryName, const std::string& DefaultValue = "") throw(TScriptException);
    virtual const std::vector<TParaValue>& GetValueListOf(const std::string& EntryName) throw(TScriptException);
    virtual void DumpTo(std::ostream& os, const std::string& Prefix = "");
    TParaValue operator[] (const std::string& EntryName) { return GetValueOf(EntryName); }
  protected:
    virtual void Construct(void) throw(TScriptException) = 0;
  protected:
    std::string _FileName;
    std::map<std::string, std::vector<TParaValue> > _EntryTable; 
  private:
    bool _IsConstructed;
    std::string _SectionName;
    std::string _Qualifier;
};


class TKiscBasicConfigFile: public TKiscConfigFile {
  public:
    TKiscBasicConfigFile(const std::string& FileName);
    virtual ~TKiscBasicConfigFile();
  protected:
    virtual void Construct(void) throw(TScriptException);
    virtual void ParseLine(TParaTokenizer& Tokenizer) throw(TScriptException);
  protected:
    std::string _CurrentSection;
};


#endif
