/* KiscDatabaseScript.hh */
/* Created by Enomoto Sanshiro on 4 December 2001. */
/* Last updated by Enomoto Sanshiro on 4 December 2001. */


#ifndef __KiscDatabaseScript_hh_
#define __KiscDatabaseScript_hh_


#include <string>
#include <deque>
#include "ParaParser.hh"
#include "KdbcManager.hh"


class TKiscDbQueryResultStack;


class TKiscDatabaseScript: public TParaParser {
  public:
    TKiscDatabaseScript(void);
    virtual ~TKiscDatabaseScript();
  protected:
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
    virtual TParaOperatorTable* CreateOperatorTable(void);
    virtual TParaStatementTable* CreateStatementTable(void);
  protected:
    TKiscDbQueryResultStack* _ResultStack;
};


class TKiscDatabaseObject: public TParaObjectPrototype {
  public:
    TKiscDatabaseObject(void);
    virtual ~TKiscDatabaseObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual void Destruct(void) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKdbcResult* ExecuteKdbcSql(const std::string& Query) throw(TScriptException);
  protected:
    TParaValue Login(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue ExecuteSql(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue GetValueOf(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  protected:
    enum {
	MethodId_Login = TParaObjectPrototype::_NumberOfMethods,
	MethodId_ExecuteSql,
	MethodId_GetValueOf,
	_NumberOfMethods
    };
  protected:
    std::string _DriverName, _DatabaseName;
    std::string _HostName, _PortNumber;
    TKdbcDriver* _Driver;
    TKdbcConnection* _Connection;
};


class TKiscDbQueryResultObject: public TParaObjectPrototype {
  public:
    TKiscDbQueryResultObject(TKdbcResult* QueryResult = 0);
    virtual ~TKiscDbQueryResultObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual void Destruct(void) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    TParaValue NumberOfRows(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue NumberOfColumns(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue NumberOfAffectedRows(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue FieldNameOf(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue Next(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue GetAt(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  protected:
    enum {
	MethodId_NumberOfRows = TParaObjectPrototype::_NumberOfMethods,
	MethodId_NumberOfColumns,
	MethodId_NumberOfAffectedRows,
	MethodId_FieldNameOf,
	MethodId_Next,
	MethodId_GetAt,
	_NumberOfMethods
    };
  protected:
    TKdbcResult* _QueryResult;
};


class TKiscDbQueryResultStack {
  public:
    TKiscDbQueryResultStack(void);
    virtual ~TKiscDbQueryResultStack();
    virtual void PushResult(TKdbcResult* QueryResult);
    virtual void PopResult(void);
    virtual TKdbcResult* GetLastResult(void);
  protected:
    std::deque<TKdbcResult*> _ResultStack;
};


class TKiscDbSqlStatement: public TParaStatement {
  public:
    TKiscDbSqlStatement(TKiscDbQueryResultStack* ResultStack);
    virtual ~TKiscDbSqlStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TParaExpression* _DbExpression;
    TParaExpression* _QueryExpression;
    TParaStatement* _Statement;
    TParaStatement* _ElseStatement;
    TKiscDbQueryResultStack* _ResultStack;
};


class TKiscDbFieldAccessOperator: public TParaOperator {
  public:
    TKiscDbFieldAccessOperator(TKiscDbQueryResultStack* ResultStack);
    virtual ~TKiscDbFieldAccessOperator();
    virtual TParaOperator* Clone(void) const;
    virtual std::string Symbol(void) const;
    virtual std::string Name(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaExpressionParser* ExpressionParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TParaValue& Evaluate(TParaValue& Left, TParaValue& Right, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException); 
  protected:
    TKiscDbQueryResultStack* _ResultStack;
};


#endif
