/* KiscMathScript.hh */
/* Created by Enomoto Sanshiro on 15 July 2008. */
/* Last updated by Enomoto Sanshiro on 15 July 2008. */


#ifndef __KiscMathScript_hh_
#define __KiscMathScript_hh_


#include "ParaParser.hh"
#include "KumaFourierTransform.hh"
#include "KumaDigitalFilter.hh"


class TKiscMathScript: public TParaParser {
  public:
    TKiscMathScript(void);
    virtual ~TKiscMathScript();
  protected:
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaOperatorTable* CreateOperatorTable(void);
    virtual TParaBuiltinFunctionTable* CreateBuiltinFunctionTable(void);
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
};


class TKiscSignalProcessingObject: public TParaObjectPrototype {
  public:
    TKiscSignalProcessingObject(void);
    virtual ~TKiscSignalProcessingObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    int FastFourierTransform(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue, int MethodId) throw(TScriptException);
    int PowerSpectrum(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue, int MethodId) throw(TScriptException);
    int DataWindow(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue, int MethodId) throw(TScriptException);
  protected:
    enum {
	MethodId_FastFourierTransform = TParaObjectPrototype::_NumberOfMethods,
	MethodId_InverseFastFourierTransform,
	MethodId_PowerSpectrumByFFT,
	MethodId_PowerSpectrumByMEM,
	MethodId_DataWindowParzen,
	MethodId_DataWindowHanning,
	MethodId_DataWindowHamming,
	MethodId_DataWindowWelch,
	MethodId_DataWindowBlackman,
	_NumberOfMethods
    };
};


class TKiscDigitalFilterObject: public TParaObjectPrototype {
  public:
    TKiscDigitalFilterObject();
    virtual ~TKiscDigitalFilterObject(void);
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);   
  protected:
    virtual void ApplyTo(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_ApplyTo = TParaObjectPrototype::_NumberOfMethods,
	_NumberOfMethods
    };
  protected:
    kuma::TKumaDigitalFilter* _DigitalFilter;
};


#endif
