/* KiscNtuple.hh */
/* Created by Enomoto Sanshiro on 10 July 2009. */
/* Last updated by Enomoto Sanshiro on 10 July 2009. */


#ifndef __KiscNtuple_hh_
#define __KiscNtuple_hh_

#include <string>
#include <vector>
#include "ParaParser.hh"
#include "KameNtuple.hh"
#include "KameGraph.hh"
#include "KameHistogram.hh"
#include "KameHistogram2d.hh"
#include "KamePlainTextRepository.hh"


class TKiscRepositoryHeaderProcessor;


class TKameUnknownParaValue: public kame::TKameUnknown {
  public:
    TKameUnknownParaValue(const TParaValue& Value);
    TKameUnknownParaValue(const TKameUnknownParaValue& Value);
    virtual ~TKameUnknownParaValue(void);
    virtual TKameUnknown* Clone(void) const;
    TParaValue& ParaValue(void);
  protected:
    TParaValue _ParaValue;
};


class TKiscKameObject {
  public:
    TKiscKameObject(void);
    virtual ~TKiscKameObject();
    virtual void SetDelimiter(const std::string& Delimiter);
    virtual void SetQuote(const std::string& Quote);
    virtual void Save(std::string FileName, std::string ObjectName) throw(TScriptException);
    virtual void Load(std::string FileName, std::string ObjectName) throw(TScriptException);
    virtual void TokenizeLine(const std::string& Line, std::vector<std::string>& TokenList) throw(TScriptException);
  protected:
    virtual void SaveTo(kame::TKameRepository* Repository, const std::string& Name) throw(TScriptException) = 0;
    virtual void LoadFrom(kame::TKameRepository* Repository, const std::string& Name) throw(TScriptException) = 0;
    virtual void OnLoad(void) throw(TScriptException) {}
  protected:
    virtual void Construct(void);
    virtual void ProcessScript(const std::string& ScriptText) throw(TScriptException);
  protected:
    std::string _Delimiter, _Quote;
    TKiscRepositoryHeaderProcessor* _HeaderProcessor;
    TParaParser* _Parser;
    TParaPackage* _Package;
    std::vector<TParaPackageEntry*> _EntryList;
    TParaExpressionParser* _ExpressionParser;
    TParaStatementParser* _StatementParser;
    TParaSymbolTable* _SymbolTable;
};


class TKiscRepositoryHeaderProcessor: public kame::TKamePlainTextHeaderProcessor {
  public:
    TKiscRepositoryHeaderProcessor(void);
    virtual ~TKiscRepositoryHeaderProcessor();
    virtual bool ProcessLine(const std::string& Line);
    virtual const std::string& ScriptText(void);
  protected:
    std::string _ScriptText;
};


class TKiscNtuple: public kame::TKameNtuple, virtual public TKiscKameObject {
  public:
    TKiscNtuple(void);
    TKiscNtuple(int NumberOfColumns);
    virtual ~TKiscNtuple();
  protected:
    virtual void SaveTo(kame::TKameRepository* Repository, const std::string& Name) throw(TScriptException);
    virtual void LoadFrom(kame::TKameRepository* Repository, const std::string& Name) throw(TScriptException);
    virtual void OnLoad(void) throw(TScriptException);
  protected:
    virtual void EvalElements(void) throw(TScriptException);
};


class TKiscGraph: public kame::TKameGraph, virtual public TKiscKameObject {
  public:
    TKiscGraph(unsigned InitialListSize = 1024);
    TKiscGraph(const kame::TKameGraph& Graph);
    virtual ~TKiscGraph();
  protected:
    virtual void SaveTo(kame::TKameRepository* Repository, const std::string& Name) throw(TScriptException);
    virtual void LoadFrom(kame::TKameRepository* Repository, const std::string& Name) throw(TScriptException);
};


class TKiscHistogram: public kame::TKameHistogram, virtual public TKiscKameObject {
  public:
    TKiscHistogram();
    TKiscHistogram(const kame::TKameHistogramScale& Scale);
    virtual ~TKiscHistogram();
  protected:
    virtual void SaveTo(kame::TKameRepository* Repository, const std::string& Name) throw(TScriptException);
    virtual void LoadFrom(kame::TKameRepository* Repository, const std::string& Name) throw(TScriptException);
};


class TKiscHistogram2d: public kame::TKameHistogram2d, virtual public TKiscKameObject {
  public:
    TKiscHistogram2d(void);
    TKiscHistogram2d(const kame::TKameHistogramScale& XScale, const kame::TKameHistogramScale& YScale);
    virtual ~TKiscHistogram2d();
  protected:
    virtual void SaveTo(kame::TKameRepository* Repository, const std::string& Name) throw(TScriptException);
    virtual void LoadFrom(kame::TKameRepository* Repository, const std::string& Name) throw(TScriptException);
};


#endif
