/* KmlcManager.hh */
/* Created by Enomoto Sanshiro on 2 June 2002. */
/* Last updated by Enomoto Sanshiro on 2 June 2002. */


#ifndef __KmlcManager_hh__
#define __KmlcManager_hh__

#include <iostream>
#include <string>
#include <map>
#include "KmlcDefs.hh"

class TKmlcFunctionMinimizer;


class TKmlcManager {
  protected:
    TKmlcManager(void);
  public:
    virtual ~TKmlcManager();
    static TKmlcManager* GetInstance(void);
    virtual void RegisterFunctionMinimizer(const std::string& Name, TKmlcFunctionMinimizer* FunctionMinimizer);
    virtual TKmlcFunctionMinimizer* CreateFunctionMinimizer(const std::string& Name = "") throw(TKmlcException);
    virtual void ShowFunctionMinimizerList(std::ostream& os) const;
  protected:
    static TKmlcManager* _Instance;
    std::map<std::string, TKmlcFunctionMinimizer*> _FunctionMinimizerTable;
};



class TKmlcFunctionMinimizerCreator {
  public:
    TKmlcFunctionMinimizerCreator(const std::string& Name, TKmlcFunctionMinimizer* FunctionMinimizer);
};


#endif
