/* KorbCommander.hh */
/* Created by Enomoto Sanshiro on 2 March 2000. */
/* Last updated by Enomoto Sanshiro on 4 February 2010. */


#ifndef __KorbCommander_hh__
#define __KorbCommander_hh__


#include <string>
#include <vector>
#include "MushProcess.hh"
#include "KorbDefs.hh"
#include "KorbNetworkAdapter.hh"
#include "KorbNetworkPacket.hh"
#include "KorbOrb.hh"
#include "KorbObjectReference.hh"


class TKorbCommander {
  public:
    TKorbCommander(TKorbOrb* Orb);
    virtual ~TKorbCommander();
    virtual int Initialize(const std::string& ProcessPathList = "") throw(TKorbException);
    virtual int Finalize(void);
    virtual int LaunchRemoteBroker(int ParentDomainId, const std::string& HostName, const std::string& ProcessPathList = "", const std::string& RemoteWorkingDirecotry = "") throw(TKorbException);
    virtual int LaunchProcess(int DomainId, const std::string& Path, const std::vector<std::string>& ArgumentList) throw(TKorbException);
    virtual void LaunchNameServer(void) throw(TKorbException);
    virtual int SendSignal(int DomainId, int ProcessId, int SignalId) throw(TKorbException);
    virtual int TerminateBroker(int DomainId = 1) throw(TKorbException);
    virtual int TerminateNameServer(void) throw(TKorbException);
  protected:
    virtual TKorbOrbPacket CreateOrbPacket(int MethodId);
    virtual int InvokeBrokerMethod(int DomainId, TKorbOrbPacket& OrbPacket, int TimeOut_sec = 0) throw(TKorbException);
  protected:    
    TKorbOrb* _Orb;
    TMushChildProcess* _BrokerProcess;
    TMushChildProcess* _NameServerProcess;
};


#endif

