/* KorbNetworkAdapter.hh */
/* Created by Enomoto Sanshiro on 4 December 1999. */
/* Updated by Enomoto Sanshiro on 6 December 2000. */
/* Last updated by Enomoto Sanshiro on 19 January 2010. */


#ifndef __KorbNetworkAdapter_hh__
#define __KorbNetworkAdapter_hh__


#include <string>
#include <deque>
#include "MushIpc.hh"
#include "KorbDefs.hh"
#include "KorbNetworkPacket.hh"


class TKorbNetworkAdapter {
  public:
    enum TFlag {
	Flag_NonBlocking = 0x01
    };
  public:
    TKorbNetworkAdapter(int AdapterId, int MessageQueueProjectId, const std::string& KorbPath);
    virtual ~TKorbNetworkAdapter();
    virtual void Attach(void) throw(TKorbException);
    virtual int DomainId(void) throw(TKorbException);
    virtual int AdapterId(void);
    virtual int Send(TKorbNetworkPacket& Packet, int Flag = 0) throw(TKorbException);
    virtual int Receive(TKorbNetworkPacket& Packet, int Flag = 0) throw(TKorbException);
    virtual int QueueCapacity(void) throw(TKorbException);
    virtual int NumberOfPendingPackets(void) throw(TKorbException);
  protected:
    virtual void InquireDomainId(void) throw(TKorbException);
  protected:
    int _DomainId;
    int _AdapterId;
    int _MessageQueueProjectId;
    std::string _KorbPath;
    TMushMessageQueue *_MessageQueue;
    std::deque<TKorbNetworkPacket> _MessagePacketQueue;
};


#endif
