/* KorbNetworkHub.hh */
/* Created by Enomoto Sanshiro on 4 December 1999. */
/* Updated by Enomoto Sanshiro on 7 February 2000. */
/* Last updated by Enomoto Sanshiro on 19 January 2010. */


#ifndef __KorbNetworkHub_hh__
#define __KorbNetworkHub_hh__


#include <string>
#include <deque>
#include <map>
#include "MushIpc.hh"
#include "MushSocket.hh"
#include "MushSocketSelector.hh"
#include "KorbNetworkPacket.hh"
#include "KorbNetworkRoutingTable.hh"


class TKorbNetworkHub {
  public:
    enum TNetworkHubParameters {
	MessageQueueAddress = 1,
	DomainId_Unknown = -1,
	_AdapterId = 1
    };
  public:
    TKorbNetworkHub(int DomainId, int MessageQueueProjectId, const std::string& KorbPath);
    virtual ~TKorbNetworkHub();
    virtual int DomainId(void) const;
    virtual void Initialize(void) throw(TKorbException);
    virtual void Finalize(void) throw(TKorbException);
    virtual void AddConnection(int RemoteDomainId, TMushSocket* Socket);
    virtual void RemoveConnection(TMushSocket* Socket);
    virtual int Send(TKorbNetworkPacket& Packet);
    virtual int Receive(TKorbNetworkPacket& Packet);
    virtual int DoTransaction(void) throw(TKorbException);
    virtual int NumberOfPendingPackets(void);
  public:
    virtual int SendToUplinkPort(int UplinkPortId, TKorbNetworkPacket& Packet) throw(TKorbException);
    virtual int SendToLocalPort(TKorbNetworkPacket& Packet) throw(TKorbException);
    virtual int ReceiveFromUplinkPort(TKorbNetworkPacket& Packet, int& UplinkPortId) throw(TKorbException);
    virtual int ReceiveFromLocalPort(TKorbNetworkPacket& Packet) throw(TKorbException);
  protected:
    virtual int ProcessPacket(TKorbNetworkPacket& Packet, int UplinkPortId = -1) throw(TKorbException);
    virtual int ProcessMessagePacket(TKorbNetworkPacket& Packet) throw(TKorbException);
    virtual int ProcessEchoRequestPacket(TKorbNetworkPacket& Packet) throw(TKorbException);
  protected:
    std::string _KorbPath;
    int _DomainId;
    int _MessageQueueProjectId;
    TKorbNetworkRoutingTable *_RoutingTable;
    TMushSocketSelector* _SocketSelector;
    TMushMessageQueue *_MessageQueue;
    TKorbNetworkPacket _Packet;
    std::map<long, TMushSocket*> _SocketTable;
    std::deque<TKorbNetworkPacket> _WaitingQueue;
    std::deque<TKorbNetworkPacket> _ReceivedPacketQueue;
    std::deque<TKorbNetworkPacket> _LocalDestinationPacketQueue;
};


#endif
