/* KorbObjectAdapter.hh */
/* Created by Enomoto Sanshiro on 27 February 2000. */
/* Last updated by Enomoto Sanshiro on 27 February 2000. */


#ifndef __KorbObjectAdapter_hh__
#define __KorbObjectAdapter_hh__


#include <string>
#include <map>
#include "KorbOrb.hh"
#include "KorbObjectReference.hh"
#include "KorbObjectMessenger.hh"


class TKorbObjectAdapter {
  public:
    enum TMethodId {
	MethodId_Exit
    };
  public:
    TKorbObjectAdapter(TKorbOrb* Orb);
    virtual ~TKorbObjectAdapter();
    virtual void AddMessenger(TKorbObjectMessenger* Messenger, const std::string& ObjectName, int ObjectId = 0) throw(TKorbException);
    virtual void RemoveMessenger(const std::string& ObjectName) throw(TKorbException);
    virtual int NumberOfMessengers(void) const;
    virtual void Start(void) throw(TKorbException);
    virtual int DoTransaction(void) throw(TKorbException);
    virtual int DoNowaitTransaction(void) throw(TKorbException);
  protected:
    virtual int ProcessRequest(int RequestId, TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int ProcessAdapterRequest(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    TKorbOrb* _Orb;
    std::map<std::string, int> _ObjectIdTable;
    std::map<int, TKorbObjectMessenger*> _MessengerTable;
    bool _IsStopRequested;
    int _NextObjectId;
};


#endif

