/* KorbObjectProxy.cc */
/* Created by Enomoto Sanshiro on 13 February 2000. */
/* Last updated by Enomoto Sanshiro on 3 February 2010. */


#include <string>
#include "KorbOrb.hh"
#include "KorbObjectReference.hh"
#include "KorbObjectAdapter.hh"
#include "KorbNamingContext.hh"
#include "KorbObjectProxy.hh"

using namespace std;



TKorbObjectProxy::TKorbObjectProxy(const string& ClassName, TKorbOrb* Orb)
{
    _ClassName = ClassName;
    _Orb = Orb;
}

TKorbObjectProxy::~TKorbObjectProxy()
{
}

const string& TKorbObjectProxy::ClassName(void) const
{
    return _ClassName;
}

void TKorbObjectProxy::AttachOrb(TKorbOrb* Orb)
{
    _Orb = Orb;
}

int TKorbObjectProxy::Bind(const string& ObjectName) throw(TKorbException)
{
    if (_Orb == 0) {
	throw TKorbException(
	    "TKorbObjectProxy::Bind()",
	    "ORB is not attached."
	);
    }

    TKorbNamingContext* NamingContext = _Orb->NamingContext();
    if (NamingContext->LookupObject(ObjectName, _ObjectReference) < 1) {
	return 0;
    }

    return Bind(_ObjectReference);
}

int TKorbObjectProxy::Bind(const TKorbObjectReference& ObjectReference) throw(TKorbException)
{
    _ObjectReference = ObjectReference;

    if (_Orb == 0) {
	throw TKorbException(
	    "TKorbObjectProxy::Bind()",
	    "ORB is not attached."
	);
    }

    if (_ObjectReference.ClassName() != _ClassName) {
	throw TKorbException(
	    "TKorbObjectProxy::Bind()",
	    "unexpected class type: " + _ObjectReference.ClassName()
	);
    }

    return 1;
}

TKorbOrbPacket TKorbObjectProxy::CreateOrbPacket(int MethodId) throw(TKorbException)
{
    if (_ObjectReference.IsNull()) {
	throw TKorbException(
	    "TKorbObjectProxy::CreateOrbPacket()",
	    "object is not binded."
	);
    }

    return _Orb->CreateClientOrbPacket(_ObjectReference, MethodId);
}

void TKorbObjectProxy::InvokeMethod(TKorbOrbPacket& OrbPacket) throw(TKorbException)
{
    _Orb->InvokeMethod(_ObjectReference, OrbPacket);
}
