/* KorbObjectProxy.hh */
/* Created by Enomoto Sanshiro on 13 February 2000. */
/* Last updated by Enomoto Sanshiro on 3 February 2010. */


#ifndef __KorbObjectProxy_hh
#define __KorbObjectProxy_hh


#include <string>
#include "KorbOrb.hh"
#include "KorbObjectReference.hh"


class TKorbObjectProxy {
  public:
    TKorbObjectProxy(const std::string& ClassName, TKorbOrb* Orb = 0);
    virtual ~TKorbObjectProxy();
    virtual const std::string& ClassName(void) const;
    virtual void AttachOrb(TKorbOrb* Orb);
    virtual int Bind(const std::string& ObjectName) throw(TKorbException);
    virtual int Bind(const TKorbObjectReference& ObjectReference) throw(TKorbException);
  protected:
    virtual TKorbOrbPacket CreateOrbPacket(int MethodId) throw(TKorbException);
    virtual void InvokeMethod(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  private:
    std::string _ClassName;
    TKorbOrb* _Orb;
    TKorbObjectReference _ObjectReference;
};

#endif
