/* KorbOrb.hh */
/* Created by Enomoto Sanshiro on 26 February 2000. */
/* Updated by Enomoto Sanshiro on 29 April 2002. */
/* Last updated by Enomoto Sanshiro on 19 January 2010. */


#ifndef __KorbOrb_hh__
#define __KorbOrb_hh__


#include <string>
#include <deque>
#include <map>
#include "KorbDefs.hh"
#include "KorbNetworkAdapter.hh"
#include "KorbNetworkPacket.hh"
#include "KorbOrbPacket.hh"
#include "KorbObjectReference.hh"

class TKorbObjectAdapter;
class TKorbNamingContext;
class TKorbNamingContextProxy;


class TKorbOrb {
  public:
    TKorbOrb(void);
    TKorbOrb(int NetworkAdapterId);
    virtual ~TKorbOrb();
    static int ProjectId(void);
    static std::string ProjectPath(void) throw(TKorbException);
    virtual int QueueCapacity(void) throw(TKorbException);
    virtual int DomainId(void);
    virtual int AdapterId(void);
  public:
    virtual void Initialize(void) throw(TKorbException);
    virtual void Finalize(void) throw(TKorbException);
    virtual TKorbObjectAdapter* ObjectAdapter(void);
    virtual TKorbNamingContext* NamingContext(void);
    virtual TKorbOrbPacket CreateServerOrbPacket(void);
    virtual TKorbOrbPacket CreateClientOrbPacket(const TKorbObjectReference& ObjectReference, int MethodId = -1);
    virtual int InvokeMethod(const TKorbObjectReference& ObjectReference, TKorbOrbPacket& OrbPacket, int TimeOut_sec = 0, bool IsAsynchronous = false) throw(TKorbException);
    virtual void SendSignal(const TKorbObjectReference& ObjectReference, int SignalId, bool IsOneWay = false) throw(TKorbException);
    virtual int TerminateAdapter(const TKorbObjectReference& ObjectReference) throw(TKorbException);
  public:
    // for "friend class TKorbObjectAdapter;"
    virtual int SendRequest(int DomainId, int AdapterId, TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int SendReplyFor(int RequestId, int DomainId, int AdapterId, TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int WaitRequest(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int GetRequest(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int WaitReplyFor(int RequestId, TKorbOrbPacket& OrbPacket, int TimeOut_sec = 0) throw(TKorbException);
  protected:
    virtual int Send(int NetworkDomainId, int NetworkAdapterId, TKorbOrbPacket& OrbPacket, bool IsNonBlocking = false) throw(TKorbException);
    virtual int Receive(TKorbOrbPacket& OrbPacket, bool IsNonBlocking = false) throw(TKorbException);
    virtual int Flush(bool IsNonBlocking) throw(TKorbException);
  protected:
    int _NetworkDomainId;
    int _NetworkAdapterId;
    int _RequestIdBase;
    int _RequestCount;
    TKorbObjectAdapter* _ObjectAdapter;
    TKorbNamingContextProxy* _NamingContext;
    TKorbNetworkAdapter* _NetworkAdapter;
    TKorbNetworkPacket _ServerNetworkPacket;
    TKorbNetworkPacket _ClientNetworkPacket;
    std::deque<TKorbNetworkPacket> _RequestPacketQueue;
    std::map<int, TKorbNetworkPacket> _ReplyPacketTable;
  private:
    std::deque<TKorbNetworkPacket> _ReceivingQueue, _SendingQueue;
};


#endif

