/* KorbOrbPacket.cc */
/* Created by Enomoto Sanshiro on 22 February 2000. */
/* Last updated by Enomoto Sanshiro on 22 February 2000. */


#include "MushConfig.hh"
#include "KorbDefs.hh"
#include "KorbSerializer.hh"
#include "KorbOrbPacket.hh"

using namespace std;
using namespace mush;


static const int HeaderAreaSize = 64;  // i.e. 8 64-bit words.


TKorbOrbPacket::TKorbOrbPacket(TKorbNetworkPacket* NetworkPacket)
{
    _NetworkPacket = NetworkPacket;

    void* Buffer = (UInt8*) NetworkPacket->DataArea() + HeaderAreaSize;
    int BufferSize = NetworkPacket->DataAreaCapacity() - HeaderAreaSize;
    _ArgumentSerializer = TKorbSerializer(Buffer, BufferSize);

    _ObjectId = -1;
    _MethodId = -1;
    _IsOneWay = 0;
    _RequestId = -1;
    _IsRequest = 1;
}

TKorbOrbPacket::TKorbOrbPacket(const TKorbOrbPacket& OrbPacket)
: _ArgumentSerializer(OrbPacket._ArgumentSerializer)
{
    _NetworkPacket = OrbPacket._NetworkPacket;

    _ObjectId = OrbPacket._ObjectId;
    _MethodId = OrbPacket._MethodId;
    _IsOneWay = OrbPacket._IsOneWay;
    _RequestId = OrbPacket._RequestId;
    _IsRequest = OrbPacket._IsRequest;
}

TKorbOrbPacket& TKorbOrbPacket::operator= (const TKorbOrbPacket& OrbPacket)
{
    _NetworkPacket = OrbPacket._NetworkPacket;
    _ArgumentSerializer = OrbPacket._ArgumentSerializer;

    _ObjectId = OrbPacket._ObjectId;
    _MethodId = OrbPacket._MethodId;
    _IsOneWay = OrbPacket._IsOneWay;
    _RequestId = OrbPacket._RequestId;
    _IsRequest = OrbPacket._IsRequest;

    return *this;
}

TKorbOrbPacket::~TKorbOrbPacket()
{
}

int& TKorbOrbPacket::ObjectId(void)
{
    return _ObjectId;
}

int& TKorbOrbPacket::MethodId(void)
{
    return _MethodId;
}

int& TKorbOrbPacket::IsOneWay(void)
{
    return _IsOneWay;
}

int& TKorbOrbPacket::RequestId(void)
{
    return _RequestId;
}

int& TKorbOrbPacket::IsRequest(void)
{
    return _IsRequest;
}

TKorbNetworkPacket* TKorbOrbPacket::NetworkPacket(void)
{
    return _NetworkPacket;
}

TKorbSerializer& TKorbOrbPacket::ArgumentSerializer(void)
{
    return _ArgumentSerializer;
}

void TKorbOrbPacket::OnReceive(void)
{
    void* Header = _NetworkPacket->DataArea();

    TKorbSerializer HeaderSerializer(Header, HeaderAreaSize);    
    HeaderSerializer.GetInt(_ObjectId);
    HeaderSerializer.GetInt(_MethodId);
    HeaderSerializer.GetInt(_IsOneWay);
    HeaderSerializer.GetInt(_RequestId);
    HeaderSerializer.GetInt(_IsRequest);

    void* Buffer = (UInt8*) _NetworkPacket->DataArea() + HeaderAreaSize;
    int BufferSize = _NetworkPacket->DataAreaCapacity() - HeaderAreaSize;
    _ArgumentSerializer = TKorbSerializer(Buffer, BufferSize);
}

void TKorbOrbPacket::OnSend(void)
{
    void* Header = _NetworkPacket->DataArea();

    TKorbSerializer HeaderSerializer(Header, HeaderAreaSize);    
    HeaderSerializer.PutInt(_ObjectId);
    HeaderSerializer.PutInt(_MethodId);
    HeaderSerializer.PutInt(_IsOneWay);
    HeaderSerializer.PutInt(_RequestId);
    HeaderSerializer.PutInt(_IsRequest);
}

int TKorbOrbPacket::PacketSize(void)
{
    return HeaderAreaSize + _ArgumentSerializer.ProcessedSize();
}

bool TKorbOrbPacket::IsPacketValid(void)
{
    return _ArgumentSerializer.IsPacketValid();
}

void TKorbOrbPacket::Dump(ostream& os)
{
    os << "object id: " << _ObjectId << endl;
    os << "method id: " << _MethodId << endl;
    os << "is oneway?: " << (_IsOneWay ? "yes" : "no") << endl;
    os << "request id: " << _RequestId << endl;
    os << "is request?: " << (_IsRequest ? "yes" : "no") << endl;

    os << "dump of NetworkPacket:" << endl;
    _NetworkPacket->Dump(os);
}
