/* LogBookOrb.cc */
/* Created by Enomoto Sanshiro on 23 February 2000. */
/* Last updated by Enomoto Sanshiro on 23 February 2000. */


#include "KorbOrb.hh"
#include "KorbObjectMessenger.hh"
#include "LogBook.hh"
#include "LogBookOrb.hh"

using namespace std;


static const char* LogBookClassName = "LogBook";


TLogBookProxy::TLogBookProxy(TKorbOrb* Orb)
: TKorbObjectProxy(LogBookClassName, Orb)
{
}

TLogBookProxy::~TLogBookProxy()
{
}

int TLogBookProxy::Write(long Date, string Name, string Contents)
{
    int MethodId = TLogBookMessenger::MethodId_Write;
    TKorbOrbPacket OrbPacket = CreateOrbPacket(MethodId);

    OrbPacket.ArgumentSerializer().PutLong(Date);
    OrbPacket.ArgumentSerializer().PutString(Name);
    OrbPacket.ArgumentSerializer().PutString(Contents);

    try {
	InvokeMethod(OrbPacket);
    }
    catch (TKorbException& e) {
	throw e;
    }

    int Result;
    OrbPacket.ArgumentSerializer().GetInt(Result);

    return Result;
}



TLogBookMessenger::TLogBookMessenger(TLogBook* LogBook)
: TKorbObjectMessenger(LogBookClassName)
{
    _LogBook = LogBook;
}

TLogBookMessenger::~TLogBookMessenger()
{
}

int TLogBookMessenger::DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException)
{
    if (OrbPacket.MethodId() == MethodId_Write) {
	long Date; string Name;	string Contents;

	OrbPacket.ArgumentSerializer().GetLong(Date);
	OrbPacket.ArgumentSerializer().GetString(Name);
	OrbPacket.ArgumentSerializer().GetString(Contents);

	int Result = _LogBook->Write(Date, Name, Contents);

	OrbPacket.ArgumentSerializer().Rewind();
	OrbPacket.ArgumentSerializer().PutInt(Result);

	return 1;
    }

    return 0;
}
